/********************************************/
/* Project: EyeView                         */
/* File   : "EyeView.c"                     */
/* Author : Frank Peters                    */
/* Date   : 2000-10-18, 2000-12-4           */
/* Notes  : Transmission of camera pictures */
/********************************************/


#include "EyeView.h"



int GetAndSendPict(int SerialPort, int ConnectorMode, int resolution)
{
    colimage img;

    // get picture
    CAMGetColFrame (&img, 0);

    // send picture
    if (ConnectorMode == radio)
    {
        WL_SEND(SerialPort);
        OSWait(2);              // wait 2 ms after switch on 
    }

    send_preface(SerialPort);   
    send_colorimage(&img, SerialPort, resolution);
    
    OSWait (20);
    if (ConnectorMode == radio) WL_RECV(SerialPort);
        
    return 1;
}



int ChangeResolution (int *resolution)
{
    if ((*resolution) == res_12bit)
    {
        (*resolution) = res_24bit;
        printf("\nRes. = 24Bit\n");
    }
    else if ((*resolution) == res_24bit)
    {
        (*resolution) = res_12bit;
        printf("\nRes. = 12Bit\n");
    }
    else
        printf("\nRes. unknown %d\n", (*resolution));
    
    return 1;   
}



void print_serialname (int port) 
{
    switch (port)
    {
        case SERIAL1:  printf ("SERIAL1");  break;
        case SERIAL2:  printf ("SERIAL2");  break;
        case SERIAL3:  printf ("SERIAL3");  break;
    }
}



void print_speed (int speed) 
{
    switch (speed)
    {
        case SER9600:   printf ("   9600");  break;
        case SER19200:  printf ("  19200");  break;
        case SER38400:  printf ("  38400");  break;
        case SER115200: printf (" 115200");  break;
    }
}



void print_mode (int mode) 
{
    switch (mode)
    {
        case cable:  printf ("  cable");  break;
        case radio:  printf ("  radio");  break;
        case irda:   printf (" IRmate");  break;
    }
}


int main ()
{
    int             CamType;    
    int             PictureNumber = 1;

    char    z;              
    
    // Defaults
    int             SerialPort    = SERIAL1;            // wireless = SERIAL2
    int             SerialSpeed   = SER115200;
    int             ConnectorMode = cable;
    int             resolution    = res_24bit;          // 0 = 12 Bit   ;  1 = 24 Bit


    // clear display and write message  
    LCDClear();
    LCDMode(SCROLLING|NOCURSOR);
    printf("EyeView V1.2\n");
    printf("by Frank Peters\n");
    
    printf("\nPort:\n"); 
    LCDSetPos (3, 7); print_serialname(SerialPort); printf("\n");
    printf("Speed:\n"); 
    LCDSetPos (4, 7); print_mode (ConnectorMode); printf("\n");
    printf("Mode:\n"); 
    LCDSetPos (5, 7); print_speed(SerialSpeed); printf("\n");
    LCDMenu("Prt","Mod","Spd","OK ");
    

    // set serial port and speed    
    z = KEYRead();
    while (  z != KEY4  )
    {
        switch (z)
        {
            case KEY1:  

                        switch (SerialPort)
                        {
                            case SERIAL1:   SerialPort  = SERIAL2;  break;
                            case SERIAL2:   SerialPort  = SERIAL3;  break;
                            case SERIAL3:   SerialPort  = SERIAL1;  break;
                        }
                        LCDSetPos (3, 7); print_serialname(SerialPort); printf("\n");   
                        break;

            case KEY2:  

                        switch (ConnectorMode)
                        {
                            case cable:  ConnectorMode  = radio;  break;
                            case radio:  ConnectorMode  = irda;   break;
                            case irda:   ConnectorMode  = cable;  break;
                        }
                        LCDSetPos (4, 7); print_mode (ConnectorMode); printf("\n");
                        break;

            case KEY3:  

                        switch (SerialSpeed)
                        {
                            case SER9600:  
                                            SerialSpeed     = SER19200;
                                            break;
                            case SER19200:  
                                            SerialSpeed     = SER38400;
                                            if (ConnectorMode == irda)
                                                SerialSpeed     = SER115200;
                                            break;
                            case SER38400:  
                                            SerialSpeed     = SER115200;
                                            if (ConnectorMode == radio)
                                                SerialSpeed     = SER9600;
                                            break;
                            case SER115200:  
                                            SerialSpeed     = SER9600;
                                            break;
                        }
                        LCDSetPos (5, 7); print_speed(SerialSpeed); printf("\n");
                        break;


        }
        z = KEYRead();
    }

    OSInitRS232(SerialSpeed,NONE,SerialPort); 
    
    if (ConnectorMode == irda)  IrDA_SetSpeed(SerialPort, SerialSpeed);


    // init menu 
    LCDClear();
    LCDMode(SCROLLING|NOCURSOR);

    printf("EyeView V1.2\n");
    printf("by Frank Peters\n");
    
    LCDMenu("One","Con","Res","END");

    
    // init camara
    CamType = CAMInit (WIDE);
    printf("\nCamType: %d\n",CamType);



    // go
    z = KEYRead();
    while (  z != KEY4  )
    {
        switch (z)
        {
            case KEY1:
                        printf("\nsend pict. %d\n",PictureNumber);
                        PictureNumber++;        
                        GetAndSendPict(SerialPort, ConnectorMode,resolution);
                        printf("OK\n");
                        break;

            case KEY2:
                        LCDMenu("   ","   ","Res","END");
                        while (  z != KEY4  )
                        {                                   
                            // send picture
                            printf("\nsend pict. %d\n",PictureNumber);
                            PictureNumber++;        
                            GetAndSendPict(SerialPort, ConnectorMode, resolution);

                            z = KEYRead();
                            if (z == KEY3)
                                ChangeResolution (&resolution);
                        }
                                                
                        LCDMenu("One","Con","Res","END");                       
                        OSWait (100);
                        break;
            case KEY3:
                        ChangeResolution (&resolution);
                        break;
        }           
        z = KEYRead();
    }
        
    return(1);
}

