/* Petter Reinholdtsen UWA October 1999
 * set /reset RTS signal on given interface.
 * RTS is active low, therefore
 *|  WL_SEND(int interface) - wireless send , set RTS
 *  WL_RECV(int interface) - wireless receive, clear RTS
 *  WL_CD(int interface)   - wireless carrier detect status
*/

#include "control.h"
#include <librobi/librobi.h>
#include <types.h>
#include <const.h>

#define BSETBIT(byte,bit)   __asm ("BSET.B %1,%0" : "=g" (byte) : "g" (bit))
#define BCLEARBIT(byte,bit) __asm ("BCLR.B %1,%0" : "=g" (byte) : "g" (bit))

/*
  Only communication on Serial2 (Ser1Base) is supported.  The assembly
  routines doing the actual sending will have to change to support the
  other ports.
*/

enum {
  MSRoffset = 6,
  MCRoffset = 4
};

void
WL_SEND(int interface)
{
  /* The memory is mapped control signals, and this address is write
     only.  We must use bset to avoid reading when setting the bit. */
  switch (interface) {
  case SERIAL2:
    {
      BYTE *MCR = (BYTE*)Ser1Base + MCRoffset;
      BSETBIT(*MCR, 1);
      break;
    }
  case SERIAL1:
  case SERIAL3:
  default:
    break;
  }
  return;
}
void
WL_RECV(int interface)
{
  /* The memory is mapped control signals, and this address is write
     only.  We must use bclr to avoid reading when setting the bit. */
  switch (interface) {
  case SERIAL2:
    {
      BYTE *MCR = (BYTE*)Ser1Base + MCRoffset;
      BCLEARBIT(*MCR, 1); /* Clear bit 1 */
      break;
    }
  case SERIAL1:
  case SERIAL3:
  default:
    break;
  }
    return;
}

int
WL_CD(int interface)
{
  switch (interface) {
  case SERIAL2:
    {
      BYTE *MSR = (BYTE*)Ser1Base + MSRoffset;
      return (*MSR & (1 << 4)); /* is bit 4 set? */
      break;
    }
  case SERIAL1:
  case SERIAL3:
  default:
    return 0;
    break;
  }
}

