/*
| -----------------------------------------------------------
| Filename: imgTrans.c
|
| Author:   Frank Peters, fpeters@epost.de, Nov 2000
|
| Description: 
| Transfer Image by Cable, wireless link, and Infrared
| -----------------------------------------------------------
*/


#include "imgTrans.h"




void send_preface(int SerialPort)
{ char k;
  int  i;

  k = 0x55; /* preamble */
  for (i=0; i<15; i++)
    OSSendRS232(&k, SerialPort);
  k = 0xff; /* lock UART */
  for (i=0; i<2; i++)
    OSSendRS232(&k, SerialPort);
  k = 0x01; /* message start */
  for (i=0; i<2; i++)
    OSSendRS232(&k, SerialPort);
  k = 0x55; 
    OSSendRS232(&k, SerialPort);
}



void IrDA_SetSpeed(int interface, int baudrate)
{

  BYTE *MCR;
  

  if ((interface == SERIAL2) || (interface == SERIAL3))
  {  

      switch (interface) 
      {

          case SERIAL2: MCR = (BYTE*)Ser1Base + MCRoffset;  break;
          case SERIAL3: MCR = (BYTE*)Ser2Base + MCRoffset;  break;
          default:      MCR = (BYTE*)Ser1Base + MCRoffset;  break;
      }
  
  
    /*  Speed-Table
        dc.b    0                       | 9,600 bps
        dc.b    1                       | 19,200 bps
        dc.b    2                       | 57,600 bps
        dc.b    3                       | 115,200 bps
    */

      switch (baudrate) 
      {

          case SER9600:
                        BCLEARBIT(*MCR, 0);
                        OSWait(1);
                        BCLEARBIT(*MCR, 1);
                        break;

          case SER19200:
                        BSETBIT(*MCR, 0);
                        OSWait(1);
                        BCLEARBIT(*MCR, 1);
                        break;

          case SER57600:
                        BSETBIT(*MCR, 1);
                        OSWait(1);
                        BCLEARBIT(*MCR, 0);
                        break;

          case SER115200:
                        BSETBIT(*MCR, 0);
                        OSWait(1);
                        BSETBIT(*MCR, 1);
                        break;

          default:
            break;
       }
  }
    
  
  return;
}



void check_send(int error_code)
{
    if (error_code != 0)    printf ("SerialError %d\n",error_code);
}



void send_colorimage (colimage *buf, int SerialPort, int mode)
// mode == 0: 12Bit  mode == 1: 24Bit 
{ 
  int i,j,m;
  unsigned char c,b1,b2;
  int fSendOK;
  char k;

 // send 62 lines
 for (j = 0; j < 62; j++) 
 {
    // synchronize every line with three characters
    k = 0xfe; /* lock UART */
    for (i=0; i<2; i++) {
        fSendOK = OSSendRS232(&k, SerialPort);
        check_send(fSendOK);
    }  
    
    k = 0x01; /* message start */
    for (i=0; i<1; i++) {
        fSendOK =  OSSendRS232(&k, SerialPort);
        check_send(fSendOK);
    }
    
    // send linenumber
    k = (char)j;
    if (mode == 1) k = k + 128; // advice hight resolution to recipient
    fSendOK = OSSendRS232(&k, SerialPort);
    check_send(fSendOK);

    m = 0;  // every second byte have to be inverted, so we need a counter
    
    // every line contains 246 Byte, we use 2 Byte in each loop
    for (i=0; i<123; i++)
    {
        if (mode == 0)  // transmit only the higher 4 bit from each byte => transmit two byte in one byte  
        {
            // get bytes
            b1 = ((char *)(*buf))[(j*246)+(2*i)];
            b2 = ((char *)(*buf))[(j*246)+(2*i+1)];
        
            // merge two bytes
            c = (b1 & 0xF0) | (b2 >> 4); 

            // invert every second byte
            if ((m % 2) == 0) {     
                c = c^0xFF;
            }
            m++;

            // send byte
            fSendOK =   OSSendRS232(&c, SerialPort);
            if (fSendOK != 0)   printf ("%d %d %d\n",j,i,fSendOK);
        }
        else if (mode == 1) // transmit every byte of the picture (hight resolution)
        {
            // get bytes
            b1 = ((char *)(*buf))[(j*246)+(2*i)];
            b2 = ((char *)(*buf))[(j*246)+(2*i+1)];
            
            // invert every second byte (in fact every 1st one ;-)
            b1 = b1^0xFF;
            
            // send bytes
            fSendOK =   OSSendRS232(&b1, SerialPort);
            if (fSendOK != 0)   printf ("%d %d %d\n",j,i,fSendOK);
            fSendOK =   OSSendRS232(&b2, SerialPort);
            if (fSendOK != 0)   printf ("%d %d %d\n",j,i,fSendOK);
            
        }
    }
 }
 
 // send linienumber 0 to indicate the recipient the end of the picture 
 k = 0xfe; /* lock UART */
 for (i=0; i<2; i++) {
    fSendOK = OSSendRS232(&k, SerialPort);
    check_send(fSendOK);
 }  
    
 k = 0x01; /* message start */
 for (i=0; i<1; i++) {
    fSendOK =  OSSendRS232(&k, SerialPort);
    check_send(fSendOK);
 }
    
 j = 0;
 k = (char)j;
 if (mode == 1) k = k + 128;        
 fSendOK = OSSendRS232(&k, SerialPort);
 check_send(fSendOK);
}

