/*
| -----------------------------------------------------------
| Filename: imgTrans.c
|
| Author:   Frank Peters, fpeters@epost.de, Nov 2000
|
| Description: 
| Transfer Image by Cable, wireless link, and Infrared
| -----------------------------------------------------------
*/


#ifndef  BOOLGRID_H
#define  BOOLGRID_H


#include <stdio.h>

#include "eyebot.h"
#include "control.h"



/* The memory is mapped control signals, and this address is write
   only.  We must use bset to avoid reading when setting the bit. */  
#define BSETBIT(byte,bit)   __asm ("BSET.B %1,%0" : "=g" (byte) : "g" (bit))
#define BCLEARBIT(byte,bit) __asm ("BCLR.B %1,%0" : "=g" (byte) : "g" (bit))



enum {
  MSRoffset = 6,
  MCRoffset = 4
};



void send_preface();                                 
// 
                

void IrDA_SetSpeed(int interface, int baudrate);
// set the speed of der IR-Module


void send_colorimage (colimage *buf, int SerialPort, int mode);   
// send a colorpicture



#endif