/* ----------------------------------------------------------------------------
| Filename: hdtvehi.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
| Description:  HDT data for VERSION-2 Eyebot Vehicle (using E-Platform)
| -----------------------------------------------------------------------------
*/
#define VERSION 1.1             /* User specific version nr. just for information */
#define NAME "Socceroo1"        /* Unique name of the platform max. 10 chars, just for information */
#define ID   0                  /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"


/* right PSD-sensor, wall = white wall of maze on table (different for other obstacles) */

short dist0[128] = {60,60,60,60,60,60,62,65,68,71,            /*   1- 20 */
                    74,77,80,82,83,85,87,88,89,90,            /*  21- 40 */
                    92,93,95,96,98,99,101,102,104,105,        /*  41- 60 */
                    107,108,110,112,114,116,118,119,121,123,  /*  61- 80 */
                    126,128,130,133,135,138,141,144,147,150,  /*  81-100 */
                    153,156,160,164,168,172,176,180,184,189,  /* 101-120 */
                    195,200,205,210,217,222,228,237,246,254,  /* 121-140 */
                    262,270,280,290,303,316,330,348,367,387,  /* 141-160 */
                    450,650,830,900,999,999,999,999,999,999,  /* 161-180 */
                    999,999,999,999,999,999,999,999,999,999,  /* 181-200 */
                    999,999,999,999,999,999,999,999,999,999,  /* 201-220 */
                    999,999,999,999,999,999,999,999,999,999,  /* 221-240 */
                    999,999,999,999,999,999,999,999};         /* 241-256 */


BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

motor_type motor0 = {2,  0, TIMER1, 8191, (void*)OutBase, 0, 1, (BYTE*)&motconv0};
motor_type motor1 = {2,  1, TIMER1, 8191, (void*)OutBase, 2, 3, (BYTE*)0};
quad_type decoder0 = {0, 3, 2, MOTOR_LEFT,  3420, 2.0};
quad_type decoder1 = {0, 4, 5, MOTOR_RIGHT, 3420, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.142}};

/* Timer2, 20ms period, 0.7ms min, 1.7ms max */
servo_type servo6 = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo7 = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo8 = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo9 = {2,  9, TIMER2, 20000, 700, 1700};

/* bump_type bumper0 = {0, 6, TIMER2, EITHER}; */
/* bump_type bumper1 = {0, 7, TIMER2, EITHER}; */

psd_type   psd0   = {0, 14, (BYTE*)InBase, 0, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)InBase, 1, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd2   = {0, 14, (BYTE*)InBase, 2, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd3   = {0, 14, (BYTE*)InBase, 3, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd4   = {0, 14, (BYTE*)InBase, 4, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
psd_type   psd5   = {0, 14, (BYTE*)InBase, 5, AH, (BYTE*)OutBase, 4, AH, (short*)&dist0};
 

info_type roboinfo = {0,PLATFORM,SER57600,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_OFF,25,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for Eyebot Vehicle                         */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD,QUAD_LEFT,"LEFT",(void *)&decoder0},
    {QUAD,QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {VW,VW_DRIVE,"Drive",(void *)&drive},

    {SERVO,SERVO6,"SERVO6",(void *)&servo6},
    {SERVO,SERVO7,"SERVO7",(void *)&servo7},
    {SERVO,SERVO8,"SERVO8",(void *)&servo8},
    {SERVO,SERVO9,"SERVO9",(void *)&servo9},

/*  {BUMP,BUMP_LEFT,"LEFT",(void *)&bumper0},   */
/*  {BUMP,BUMP_RIGHT,"RIGHT",(void *)&bumper1}, */

    {PSD,PSD_FRONT,    "FRONT", (void *)&psd0},
    {PSD,PSD_LEFT,     "LEFT",  (void *)&psd1},
    {PSD,PSD_RIGHT,    "RIGHT", (void *)&psd2},
    {PSD,PSD_LEFTDIAG, "LEFTD", (void *)&psd3},
    {PSD,PSD_RIGHTDIAG,"RIGHTD",(void *)&psd4},
    {PSD,PSD_BACK,     "BACK",  (void *)&psd5},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},
    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};


