#ifndef  LIBROBI_H
#define  LIBROBI_H

/* some includes we always need */

#if defined(__mc68000__)
#  include <_ansi.h>    /* ...instead of this, which the m68k libx calls it */
#elif !defined(_WIN32)
#  include <ansidecl.h>	/* libc for x86 calls it this... */
#endif
#include <errno.h>

extern char _end[];                /* _end is set in the linker command file */

#ifdef errno
#  define SET_ERRNO(x)  errno = x
#else
#  define SET_ERRNO(x)
#endif

/* Definition of Filedescriptors for 6833x Microcontrollers */

/* 33x internal IO ports */

#define STDIN           0
#define STDOUT          1
#define STDERR          2

#define QSMASYNC        30              /* asynchronous QSM port */
#define SERIAL1         QSMASYNC
#define QSMSYNC1        31              /* synchronous QSM ports */
#define SERIAL2         QSMSYNC1
#define QSMSYNC2        32
#define SERIAL3         QSMSYNC2
#define QSMSYNC3        33
#define SERIAL4         QSMSYNC3
#define QSMSYNC4        34

#define	SER1		"ser1"
#define	SER2		"ser2"
#define	SER3		"ser3"

/* Keyboard & Display */
#define LCDALNUM        10              /* alphanumeric LCD */
#define LCDGRAPH        11              /* graphic LCD */
#define KEYB            15              /* Keyboard */

/* optional NS16552 */
#define DUART1          20              /* first async port */
#define DUART2          21              /* second async port */
#define CENT            25              /* centronics interface */

#endif

