// RTTI support for -*- C++ -*-
// Copyright (C) 1994, 95-97, 1998 Free Software Foundation

#ifndef __TYPEINFO__
#define __TYPEINFO__

#pragma interface "typeinfo"

#include <exception>

extern "C++" {

namespace std {

class type_info {
private:
  // assigning type_info is not supported.  made private.
  type_info& operator= (const type_info&);
  type_info (const type_info&);

protected:
  explicit type_info (const char *n): _name (n) { }

  const char *_name;

public:
  // destructor
  virtual ~type_info ();
    
  bool before (const type_info& arg) const;
  const char* name () const
    { return _name; }
  bool operator== (const type_info& arg) const;
  bool operator!= (const type_info& arg) const;
};

inline bool type_info::
operator!= (const type_info& arg) const
{
  return !operator== (arg);
}

class bad_cast : public exception {
public:
  bad_cast() { }
  virtual ~bad_cast() { }
};

class bad_typeid : public exception {
 public:
  bad_typeid () { }
  virtual ~bad_typeid () { }
};

} // namespace std

} // extern "C++"
#endif
