/*
| -----------------------------------------------------------------------------
| Filename: hdtsocc.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
|               Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
| Description:
| -------
| HDT data for EyeBot MK3, UWA Sep. 1998, modified for soccerbot
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1           /* User specific version nr. for information */
#define NAME "Vinko"        /* Unique name of the platform max. 10 chars, just for information */
#define ID   5                /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* PSD-sensor #0 (R5P0-L), range 70 - 540 mm */
short distleft[128] =
  { 70,70,70,70,70,70,70,70,70,70, /* 1 - 20 */
    70,70,70,70,70,70,70,72,74,76, /* 21 - 40 */
    78,81,82,84,86,88,90,92,94,96, /* 41 - 60 */
    98,100,102,104,106,108,111,113,115,117, /* 61 - 80 */
    120,122,125,127,130,132,135,137,140,143, /* 81 - 100 */
    151,155,160,164,168,181,175,181,185,191, /* 101 - 120 */
    195,202,208,215,222,230,240,245,251,262, /* 121 - 140 */
    275,285,296,305,320,338,348,365,374,378, /* 141 - 160 */
    407,412,435,445,495,540,9999,9999,9999,9999, /* 161 - 180 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999}; /* 241 - 256 */

/*
 * PSD-sensor #1 (Front), range 82 - 417 mm
 * wall = white wall of soccer field (different for other obstacles)
 */
short distfront[128] =
  { 82,82,82,82,82,82,82,82,82,88,                     /*   1 -  20 */
    88,89,93,95,97,98,100,102,104,105,                 /*  21 -  40 */
    107,108,110,111,113,114,116,119,120,121,           /*  41 -  60 */
    123,126,129,132,134,137,138,139,143,146,           /*  61 -  80 */
    148,151,153,161,161,169,169,173,177,181,           /*  81 - 100 */
    184,186,188,200,196,208,210,216,226,222,           /* 101 - 120 */
    240,230,242,250,252,260,266,268,280,280,           /* 121 - 140 */
    296,286,299,305,309,317,323,331,329,359,           /* 141 - 160 */
    345,373,359,387,381,417,9999,9999,9999,9999,       /* 161 - 180 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999};          /* 241 - 256 */

/* PSD-sensor #2 (R5P2-R), range 60 - 495 mm */
short distright[128] =
  { 60,60,60,60,60,60,60,60,60,63, /* 1 - 20 */
    64,66,69,70,73,75,77,79,81,83, /* 21 - 40 */
    84,85,86,88,89,91,92,93,96,98, /* 41 - 60 */
    100,102,103,105,107,109,112,114,116,119, /* 61 - 80 */
    121,124,127,132,134,137,143,148,152,157, /* 81 - 100 */
    162,167,172,179,183,186,194,200,206,213, /* 101 - 120 */
    226,230,236,242,253,262,272,283,295,305, /* 121 - 140 */
    330,345,356,372,400,415,430,455,470,495, /* 141 - 160 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 161 - 180 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999}; /* 241 - 256 */

short dist3[128] = { 60,60,60,60,70,80,82,84,86,88,           /*   1- 20 */
                     90,92,94,96,97,99,101,102,103,106,       /*  21- 40 */
                     107,109,111,113,115,118,120,123,127,131, /*  41- 60 */
                     134,137,140,143,146,149,154,159,164,169, /*  61- 80 */
                     173,176,180,185,192,199,204,209,215,220, /*  81-100 */
                     224,227,232,238,241,247,251,256,261,268, /* 101-120 */
                     275,281,288,293,297,302,308,315,320,325, /* 121-140 */
                     332,342,353,356,365,373,380,393,405,413, /* 141-160 */
                     430,442,459,475,485,510,535,552,570,600, /* 161-180 */
                     630,660,9999,9999,9999,9999,9999,9999,9999,9999, /* 181-200 */
                     9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201-220 */
                     9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221-240 */
                     9999,9999,9999,9999,9999,9999,9999,9999};        /* 241-256 */


/* PSD-sensor #4, wall = white wall of soccer field (different for other obstacles) */
short dist4[128] = { 60,60,60,60,60,60,62,65,68,71,            /*   1- 20 */
                     74,77,80,82,83,85,87,88,89,90,            /*  21- 40 */
                     92,93,95,96,98,99,101,102,104,105,        /*  41- 60 */
                     107,108,110,112,114,116,118,119,121,123,  /*  61- 80 */
                     126,128,130,133,135,138,141,144,147,150,  /*  81-100 */
                     153,156,160,164,168,172,176,180,184,189,  /* 101-120 */
                     195,200,205,210,217,222,228,237,246,254,  /* 121-140 */
                     262,270,280,290,303,316,330,348,367,387,  /* 141-160 */
                     450,650,830,900,9999,9999,9999,9999,9999,9999,  /* 161-180 */
                     9999,9999,9999,9999,9999,9999,9999,9999,9999,9999,  /* 181-200 */
                     9999,9999,9999,9999,9999,9999,9999,9999,9999,9999,  /* 201-220 */
                     9999,9999,9999,9999,9999,9999,9999,9999,9999,9999,  /* 221-240 */
                     9999,9999,9999,9999,9999,9999,9999,9999};         /* 241-256 */



BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
motor_type motor0 = {2,  1, TIMER1, 8191, (void*)OutBase, 3, 2, (BYTE*)&motconv0};
motor_type motor1 = {2,  0, TIMER1, 8191, (void*)OutBase, 0, 1, (BYTE*)&motconv0};
quad_type decoder0 = {0, 2, 3, MOTOR_LEFT,  3235, 2.0};
quad_type decoder1 = {0, 5, 4, MOTOR_RIGHT, 3235, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.084}};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo11 = {2, 12, TIMER2, 20000, 2300,1500}; /* camera */
servo_type servo12 = {2, 13, TIMER2, 20000, 1700,1540}; /* kicker */


/* PSD-infrared */
psd_type psdleft  = {0, 14, (BYTE*)InBase, 0, AH, (BYTE*)OutBase, 4, AH, (short*)&distleft};
psd_type psdfront = {0, 14, (BYTE*)InBase, 1, AH, (BYTE*)OutBase, 4, AH, (short*)&distfront};
psd_type psdright = {0, 14, (BYTE*)InBase, 2, AH, (BYTE*)OutBase, 4, AH, (short*)&distright};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* this is a test HDT structure which contains ALL EyeBot hardware devices */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD, QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {QUAD, QUAD_LEFT,"LEFT",(void *)&decoder0},
    {VW,VW,"Drive",(void *)&drive},

    /* {BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0}, */
    /* {IR, IR_LF,"LF",(void *)&ir0},             */

    {SERVO,SERVO11,"S11-C",(void *)&servo11},
    {SERVO,SERVO12,"S12-K",(void *)&servo12},

    {PSD,PSD_LEFT,      "P0-L", (void *)&psdleft},
    {PSD,PSD_FRONT,     "P1-F", (void *)&psdfront},
    {PSD,PSD_RIGHT,     "P2-R", (void *)&psdright},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

