/*
| -----------------------------------------------------------------------------
| Filename: andy-h.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
| 
| Description: 
| -------
| HDT for Andy Droid, EyeBot MK4, UWA Aug. 2001
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1      /* User specific version nr. for information */
#define NAME "Andy"      /* controller name max. 7 chars, inform. only */
#define ID   3           /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"
#include "startup.h"      /* include startup sound and image */


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type _LHipSide   = {2,  9, TIMER2, 20000, 1392, 1152};
servo_type _LHipBend   = {2, 10, TIMER2, 20000, 760, 2344};
servo_type _LKnee      = {2, 11, TIMER2, 20000, 2272, 560};
servo_type _LAnkleBend = {2, 12, TIMER2, 20000, 2164, 580};
servo_type _LAnkleSide = {2, 13, TIMER2, 20000, 1444, 1004};
servo_type _LArm       = {2,  8, TIMER2, 20000, 500, 1884};

servo_type _RHipSide   = {2,  3, TIMER2, 20000, 1380, 1140};
servo_type _RHipBend   = {2,  4, TIMER2, 20000, 2468, 884};
servo_type _RKnee      = {2,  5, TIMER2, 20000, 684, 2412};
servo_type _RAnkleBend = {2,  6, TIMER2, 20000, 768, 2352};
servo_type _RAnkleSide = {2,  7, TIMER2, 20000, 1428, 1188};
servo_type _RArm       = {2,  2, TIMER2, 20000, 2240, 840};
servo_type _Head       = {2, 14, TIMER2, 20000, 1000, 1384};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,VEHICLE,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,33,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

HDT_entry_type HDT[] =
{                   
    {SERVO,L_HipSide,   "LHipS1",(void *)&_LHipSide},
    {SERVO,L_HipBend,   "LHipB2",(void *)&_LHipBend},
    {SERVO,L_Knee,      "LKnee3",(void *)&_LKnee},
    {SERVO,L_AnkleBend, "LAnkB4",(void *)&_LAnkleBend},
    {SERVO,L_AnkleSide, "LAnkS5",(void *)&_LAnkleSide},
    {SERVO,L_Arm,       "LArm06",(void *)&_LArm},
    {SERVO,R_HipSide,   "RHipS7",(void *)&_RHipSide},
    {SERVO,R_HipBend,   "RHipB8",(void *)&_RHipBend},
    {SERVO,R_Knee,      "RKnee9",(void *)&_RKnee},
    {SERVO,R_AnkleBend, "RAnkBA",(void *)&_RAnkleBend},
    {SERVO,R_AnkleSide, "RAnkSB",(void *)&_RAnkleSide},
    {SERVO,R_Arm,       "RArm0C",(void *)&_RArm},
/*  {SERVO,Head,        "Head0D",(void *)&_Head}, */
                    
    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},
    
    {STARTMELODY,STARTMELODY,"Melody",(void *)startmelody},
    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},
    
    
    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

