
#ifdef  START_MONITOR_ON_RESET

 // START RT-MONITOR ON RESET OR POWER ON
 #pragma cdata[0] = /*BSF*/0x1400 + /*PCLATH*/10 + (/*bit*/3 << 7)
 #pragma cdata[1] = /*BSF*/0x1400 + /*PCLATH*/10 + (/*bit*/4 << 7)
 #pragma cdata[2] = /*GOTO*/0x2800 + 0x7FE

 #pragma resetVector 3

  /* NOTE: if the monitor/downloader should be started directly at
     reset or power on, then the above cdata statements should be
     included by defining START_MONITOR_ON_RESET.
     However, this is NOT recommended for 2 reasons:
      1) ICD debugging requires a NOP at address 0
      2) Later compilations/downloads must then ALWAYS define this
         macro. Otherwise the PCL=3 statement inserted at at end of
         monitor() will not hit the user resetVector.
  */

#endif



/* LOADER_START should be adjusted according to the features enabled.
   No user program can exceed the LOADER_START address */

#ifdef __CC5XFREE__
 #if defined _16F876A || defined _16F877A
  #define LOADER_START  0x1C4D
  #define MonPage page3
  #define BLOCK_WRITE
 #elif defined _16F873A || defined _16F874A
  #define LOADER_START  0xC4E
  #define MonPage page1
  #define BLOCK_WRITE
 #elif __CodePages__ == 4
  #define LOADER_START  0x1CC6
  #define MonPage page3
 #elif __CodePages__ == 2
  #define LOADER_START  0xCD0
  #define MonPage page1
 #else
  #define LOADER_START  0x4DE
  #define MonPage
 #endif
#else
 #if defined _16F876A || defined _16F877A
  #define LOADER_START  0x1D0E
  #define MonPage page3
  #define BLOCK_WRITE
 #elif defined _16F873A || defined _16F874A
  #define LOADER_START  0xD13
  #define MonPage page1
  #define BLOCK_WRITE
 #elif __CodePages__ == 4
  #define LOADER_START  0x1D73
  #define MonPage page3
 #elif __CodePages__ == 2
  #define LOADER_START  0xD82
  #define MonPage page1
 #else
  #define LOADER_START  0x595
  #define MonPage
 #endif
#endif

/*
   When loading a new application using the downloader, this code
   will not (should not) contain the monitor code (code in the
   monitor area will be ignored). It is recommended to insert the
   following statement at the end of an application without the
   monitor code to allow detection of overlapping code during
   compilation.

     #pragma origin LOADER_START  // error on overlapping code

   A loaded application can start the monitor/downloader by making
   a call to a certain address. The compiler will do the page bit
   updating if a link function is put on the same codepage as the
   monitor:

   MonPage void monitorLink1(void)
   {
       W = 0;    // normal return (if RTMONITOR is defined)
       //W = 1;  // restart application after new download
      #asm
       DW /*CALL*/0x2000 + 0x7FF   // monitor restart address
      #endasm
      #if __CC5X__ <= 3106  // version 3.1F and earlier
       STATUS = 0;   // make sure bank bits are updated on return
      #endif
   }

   or:

   MonPage void monitorLink2(char W)
   // W = 1: startup, goto start-vector on exit (restart application)
   // W = 0: normal return (if RTMONITOR defined)
   {
      #asm
       DW /*CALL*/0x2000 + 0x7FF  // monitor restart address
      #endasm
      #if __CC5X__ <= 3106  // version 3.1F and earlier
       STATUS = 0;   // make sure bank bits are updated on return
      #endif
   }



   It is possible to do the page bit updating by DW statements,
   but this is normally not recommended:

      #asm
       DW /*BSF*/0x1400 + /*PCLATH*/10 + (/*bit*/3 << 7)
       DW /*BSF*/0x1400 + /*PCLATH*/10 + (/*bit*/4 << 7)
       DW /*CALL*/0x2000 + 0x7FF
       // PCLATH needs to be updated after return
       // updating when current codepage is page 0
       DW /*BCF*/0x1000 + /*PCLATH*/10 + (/*bit*/3 << 7)
       DW /*BCF*/0x1000 + /*PCLATH*/10 + (/*bit*/4 << 7)
      #endasm
      #if __CC5X__ <= 3106  // version 3.1F and earlier
       STATUS = 0;   // make sure bank bits are updated on return
      #endif

*/

