
// THIS DEMO PROGRAM IS A NEW APPLICATION TO BE LOADED
// .. INCLUDES HARD CODED BREAKPOINTS AND TESTPOINTS

//#pragma chip PIC16F870
//#pragma chip PIC16F871
//#pragma chip PIC16F873
//#pragma chip PIC16F874
//#pragma chip PIC16F876
#pragma chip PIC16F877
//#pragma chip PIC16F873A
//#pragma chip PIC16F874A
//#pragma chip PIC16F876A
//#pragma chip PIC16F877A

#include "rtmon.h"


#define BREAKPOINTS   /* 8 hard coded breakpoints (execution stops) */
#define TESTPOINTS    /* 8 hard coded test points (stop at page full) */

/*
   BREAKPOINTS: This simple implementation of application supported
   breakpoints will stop application execution when encountering an
   enabled breakpoint. The characters 'B' + breakpoint number (0-7)
   are transmitted on the serial line (to a display/terminal
   program). The RT-monitor is then called and displays the
   prompt ('>'). It is now possible to inspect RAM and EEPROM memory
   locations. Resuming application execution is simply the <Enter>
   key.

   TESTPOINTS are similar to the breakpoints except that the
   application program is not stopped unless a certain number of
   testpoints have been displayed. This implementation of testpoints
   allows the testpoint number to be displayed plus an additional
   value or variable.

   Note that breakpoints and testpoints are not part of the RT-
   monitor. They must be embedded in the application. The
   breakpoints and testpoints can be enabled or disabled by changing
   the right RAM locations when the RT-monitor stops program
   execution.
*/


MonPage void linkMonitor(char W)
// W = 0;  // normal return (if RTMONITOR is defined)
// W = 1;  // restart application on EXIT (after new download)
{
   #asm
    DW /*CALL*/0x2000 + 0x7FF  // monitor restart address
   #endasm
   #if __CC5X__ <= 3106  // version 3.1F and earlier
    STATUS = 0;   // make sure bank bits are updated on return
   #endif
}


#pragma codepage 0
#pragma rambank 0


// BAUDRATE = 19200, ClockFrequency == 4000000 // 4 MHz
#define SPBRG_RATE    13 - 1
#define TXEN_transmit_enable  0x20
#define BRGH_async_high_speed 0x04
#define SPEN_Serial_Port_Enable 0x80
#define CREN_receive_enable     0x10

bit TRIS_TX @ TRISC.6;
bit TRIS_RX @ TRISC.7;

#define CR 13
#define LF 10


void putChar(char ch)
{
    while (!TXIF)  // SERIAL-IO
        ;  // wait until previous character transmitted
    TXREG = ch;    // clear TXIF
}


char toHex(char c)
{
    c &= 0xF;
    c += '0';
    if (c > '9')
        c += 'A' - '9' - 1;
    return c;
}

void putHex(char digit)
{
    putChar(toHex(swap(digit)));
    putChar(toHex(digit));
}



#ifdef BREAKPOINTS

 void breakN(char n)
 {
     putChar('B');
     putChar(n);
     linkMonitor(0);  // call RT-monitor
 }

 char breakpoints;

 #define  bp(n)  { \
     W = n+'0';     \
     if (breakpoints & (1<<n)) \
         breakN(W); \
 }

#else

 #define  bp(n)   // empty

#endif


#ifdef TESTPOINTS

 char testpoints;
 char lineNumber;
 #define NoOfScreenLines   20

 void testpointN(char n)
 {
     putChar('T');
     putChar(n);
     putChar(',');
 }

 void testpointD(char W)
 {
     putHex(W);
     putChar(',');
 }

 void testpointN_(char W)
 {
     putHex(W);
     putChar(CR);
     putChar(LF);
     lineNumber --;
     if (lineNumber != 0)
         return;
     lineNumber = NoOfScreenLines;
     linkMonitor(0);
 }

 #define  tp(n,d)  { \
     if (testpoints & (1<<n)) { \
         testpointN(n+'0'); \
         testpointN_(d); \
     } \
 }

 #define  tpe(n,d,e)  { \
     if (testpoints & (1<<n)) { \
         testpointN(n+'0'); \
         testpointD(d); \
         testpointN_(e); \
     } \
 }

#else

 #define  tp(n,d)         // empty
 #define  tpe(n,d,e)      // empty

#endif


void delay_ms( char millisec)
{
    // delays up to 256 milliseconds (at 4 MHz clock)
    // Timer 1 increments by 1 each second microsecond
    T1CON = 0b.00.11.000.1;  // Fosc/4 + prescaler div 8
     // - - T1CKPS1 T1CKPS0 T1OSCEN T1SYNC TMR1CS TMR1ON
     // T1CKPS1:T1CKPS0: Timer1 Input Clock Prescale Select bits
     //  11 = 1:8 Prescale value
     //  10 = 1:4 Prescale value
     //  01 = 1:2 Prescale value
     //  00 = 1:1 Prescale value
     // T1OSCEN = 0 : Timer1 Oscillator is disabled
     // T1SYNC = x: Timer1 External Clock Input Synchronization Select bit
     // TMR1CS = 0 : Internal clock (FOSC/4)
     // TMR1ON = 1 : Enables Timer1
    char next = TMR1L;
    do  {
        next += 125;
        while (TMR1L != next)
            ;
    } while (--millisec > 0);
}




void main(void)
{
    // initialize IO (depends on circuit board)

    // if (IO_pin == 0)
    //    linkMonitor(1);   // conditional start monitor/downloader

   #if defined BREAKPOINTS  || defined TESTPOINTS
    // Init serial port
    TRIS_TX = 0;  // TX-pin is output
    TRIS_RX = 1;  // RX-pin is input
    SPBRG = SPBRG_RATE;
    TXSTA = TXEN_transmit_enable | BRGH_async_high_speed;
    RCSTA = SPEN_Serial_Port_Enable | CREN_receive_enable;
   #endif

   #ifdef BREAKPOINTS
    breakpoints = 0xFF;  // all enabled
   #endif

   #ifdef TESTPOINTS
    testpoints = 0xFF;  // all enabled
    lineNumber = NoOfScreenLines;
    {
        char i;
        for (i = 0; i < 50; i++)  {
            tpe(1,i,i+1);
            if (i == 25)
                bp(3);
        }
        tp(2,12);
    }
   #endif

    char i;
    for (i = 0; i < 3*4; i++)
        delay_ms(250);

    putChar('Z');
    putChar('Z');
    putChar('!');

    bp(2);

    nop();

    linkMonitor(0);  // normal return from monitor

    nop();

    linkMonitor(1);  // restart application on exit from monitor
}


#pragma origin LOADER_START
// Application code can NOT overlap with monitor/loader code
