
// CONFIGURATION DEFINITIONS (FOR CUSTOMIZATION)

#ifndef ClockFrequency
 #define ClockFrequency    4000000  // 4 MHz
#endif

#ifndef BAUDRATE
 #define BAUDRATE          19200
#endif

#define MinDelayAfterXOFF 3  // in milliseconds (range 1-25)

#define ExtraBufferSize   10  // maximum characters received after XOFF


// Features can be disabled/enabled by inserting/removing the
//  comment ('//') in front of the #define statement

// Features to be included
// FULL size : around 653 code words for 16F87X, and 754 words for 16F87XA
// .. the FREE CC5X edition generates more code : 829 and 947 code words
#define DOWNLOADER        // (163 Words) enable downloader
#define RTMONITOR         // (215 Words) enable rt-monitor
#define HELPINFO          // (49/54 Words) enable minimal help info
#define EXECUTE_SINGLE    // (15/20 Words) enable single function execution
#define WATCHDOG_ENABLED  // (1 Word) regularly perform CLRWDT
#define ENABLE_INHX32  // (2 Words) accept INHX32 (in addition to INHX8M)
#define AUTOSTART   // automatic start program after loading (EOF-record)
#define WRITE_DOT   // (2 Words) write '.' for each INHX8M record
#define RESTORE_GIE // (4 Words) restore GIE on exit (otherwise set to 0)


/* When AUTOSTART is defined, there will always be a full restart of
   the application when the EOF record is detected during download,
   independent of the parameter used when calling the monitor
   routine (i.e. both for monitor(0) and monitor(1)). */

/* Baud rate calculation:
   - assuming async high speed (BRGH=1)

   - note that the error should be kept low (< 1 %) when selecting a
     baud rate for an oscillator frequency. The error is found by
     dividing the decimal value found using the formula by the
     integer value actually stored in the SPBRG register (and then
     subtract 1).

     SPBRG_RATE = value in SPBRG (0-255)
     SPBRG_RATE = (ClockFrequency / (BAUDRATE * 16)) - 1
*/

#if BAUDRATE == 19200  && ClockFrequency == 4000000 // 4 MHz
 #define SPBRG_RATE    13 - 1
#elif BAUDRATE == 38400  && ClockFrequency == 8000000 // 8 MHz
 #define SPBRG_RATE    13 - 1
#elif BAUDRATE ==  9600  && ClockFrequency == 4000000 // 4 MHz
 #define SPBRG_RATE    26 - 1
#elif BAUDRATE == 19200  && ClockFrequency == 8000000 // 8 MHz
 #define SPBRG_RATE    26 - 1
#elif BAUDRATE == 38400  && ClockFrequency == 16000000 // 16 MHz
 #define SPBRG_RATE    26 - 1
#elif BAUDRATE ==  9600  && ClockFrequency == 8000000 // 8 MHz
 #define SPBRG_RATE    52 - 1
#elif BAUDRATE == 19200  && ClockFrequency == 16000000 // 16 MHz
 #define SPBRG_RATE    52 - 1
#elif BAUDRATE == 19200  && ClockFrequency == 20000000 // 20 MHz
 #define SPBRG_RATE    65 - 1
#elif BAUDRATE ==  9600  && ClockFrequency == 16000000 // 16 MHz
 #define SPBRG_RATE   104 - 1
#else
 #error SPBRG register value is not (yet) calculated for this combination
#endif


// OTHER DEFINITIONS

#define TXEN_transmit_enable  0x20
#define BRGH_async_high_speed 0x04

#define SPEN_Serial_Port_Enable 0x80
#define CREN_receive_enable     0x10


bit TRIS_TX @ TRISC.6;
bit TRIS_RX @ TRISC.7;



// the last locations in the last bank are used for the downloader/rt-monitor
#if defined RTMONITOR && defined DOWNLOADER
 #define UserAppArea   57 - ExtraBufferSize
#elif defined DOWNLOADER
 #define UserAppArea   63 - ExtraBufferSize
#elif defined RTMONITOR
 #define UserAppArea   84 - ExtraBufferSize
#endif

#if defined _16F876 || defined _16F877 || defined _16F876A || defined _16F877A
 #define BANK_RTM 3  // where to locate local and global variables
 //char reserved[UserAppArea] @ 0x190;  // optional, for application data
 #define TenthMilliSec (ClockFrequency/4/10000/10) // 10 instr. cycles per loop

#elif defined _16F873 || defined _16F874 || defined _16F873A || defined _16F874A
 #define BANK_RTM 1  // where to locate local and global variables
 //char reserved[UserAppArea] @ 0xA0;   // optional, for application data
 #define TenthMilliSec (ClockFrequency/4/10000/8) // 8 instr. cycles per loop

#elif defined _16F870 || defined _16F871
 #define BANK_RTM 0  // where to locate local and global variables
 //char reserved[UserAppArea-20] @ 0x20; // optional, for application data
 #define TenthMilliSec (ClockFrequency/4/10000/6) // 6 instr. cycles per loop

#else
 #error Undefined device
#endif


#define unknownCommand()      putChar('E')


#pragma rambank BANK_RTM

#ifdef DOWNLOADER
 uns16 noOfCodeWords;
 char downloadErrors;
 #define lineOverflow()        downloadErrors |= 0x1
 #define dataLost()            downloadErrors |= 0x2
 #define framingOrOverflow()   downloadErrors |= 0x4
 #define recordFramingError()  downloadErrors |= 0x8
 #define RecordFramingError    0x8
 #define ChecksumError         0x10
 #define RecordTypeError       0x20
 #define programmingFailed()   downloadErrors |= 0x40
 #define DownloaderOverwrite   0x80

 char xBuffer[ExtraBufferSize];
 char iXtra;
 char maxXtra;

 #define NoOfKTab  21  // 1+2+1+16+1

#else

 #define lineOverflow()
 #define framingOrOverflow()
 #define programmingFailed()

 #define DownloaderOverwrite   0x80

 #define NoOfKTab  10   // allows M 1234 = 1234

#endif


// :BBaaaaTT112233...CC  : ASCII INTEL record
// comTab[] = 'BaaT123...C' : compressed record
char comTab[NoOfKTab];  // must reside on same bank as progBuffer[]
char comI;

#define dataAddressH comTab[1]
#define dataAddressL comTab[2]

#define dataWord1L   comTab[4]
#define dataWord1H   comTab[5]

#ifdef RTMONITOR
 uns16 memAddress;
#endif


#ifdef BLOCK_WRITE
 #define NoOfProgBuffer 8
 #define ProgBufferMask (NoOfProgBuffer-1)
 uns8 progBuffer[NoOfProgBuffer];  // must reside on same bank as comTab[]
 uns16 baseAddrProg;  // start of progBuffer
 bit progBufferInit;
#endif


char rtFlags;
 bit startUp   @ rtFlags.0;
 bit errorFlag @ rtFlags.1;
 bit eof       @ rtFlags.2;
 bit intelHex  @ rtFlags.3;
 bit retest    @ rtFlags.4;
 bit echo      @ rtFlags.5;
 bit savedGIE  @ rtFlags.6;

#define XON  0x11
#define XOFF 0x13

#define CR 13
#define LF 10
#define ESC 27
#define DEL 8


void putChar(char ch);
void putHex(char digit);
void monitor(char W);
void linkMonitor(void);



