#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <jpeglib.h>
#include "save.h"
#include "frontend.h"






struct Page_Ppm page_ppm;
struct Page_Jpeg page_jpeg;
GtkWidget *textbox;


void select_ok(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_entry_set_text(GTK_ENTRY(textbox), gtk_file_selection_get_filename(GTK_FILE_SELECTION (widget)));
  gtk_widget_destroy(GTK_WIDGET(widget));
  return;
}

void select_cancel(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(widget));
  return;
}

void file_select(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  GtkWidget *fileselect;

  if (!frozen)
    gtk_idle_remove(timeoutid);
  fileselect = gtk_file_selection_new("Save Image");
  gtk_widget_show(fileselect);

  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fileselect)->cancel_button), "clicked", (GtkSignalFunc) select_cancel, GTK_OBJECT (fileselect));

  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fileselect)->ok_button), "clicked", (GtkSignalFunc) select_ok, GTK_OBJECT (fileselect));

  return;
}


void save_ok(GtkWidget *widget, gpointer data)
{
  int ls=0, x, y;
  int i;
  int lines, pixels_per_line;
  FILE *outfile;
  unsigned char buff[3];

  struct jpeg_compress_struct cinfo;
  struct jpeg_error_mgr jerr;
  JSAMPROW row_pointer[1];     // pointer to JSAMPLE row(s)
  int row_stride;              // physical row width in image buffer

  if(!(outfile = fopen(gtk_entry_get_text(GTK_ENTRY(textbox)), "w"))){
    printf("Need a file name...\n");
    return;
  }
  
  switch (gtk_notebook_get_current_page(data)) {
  case ppm:
    if (GTK_TOGGLE_BUTTON(page_ppm.radio_raw_ppm)->active){  
      fprintf (outfile, "P6\n%d %d\n%d\n", vid_win.width, vid_win.height, 255);
      for (i = 0; i < vid_win.width*vid_win.height*3; i+=3){
	buff[0] = pic[i];
	buff[1] = pic[i+1];
	buff[2] = pic[i+2];
	fwrite (buff, 1, 3, outfile);
      }
    }
    else if (GTK_TOGGLE_BUTTON(page_ppm.radio_ascii_ppm)->active){
      fprintf (outfile, "P3\n%d %d\n%d\n", vid_win.width, vid_win.height, 255);
      for (i = 0; i < vid_win.width*vid_win.height*3; i+=3){
	fprintf (outfile, "%03d %03d %03d  ", pic[i], pic[i+1], pic[i+2]);
      }
    }
    break;
  case jpeg:
    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_compress(&cinfo);
    
    jpeg_stdio_dest(&cinfo, outfile);
    cinfo.image_width = vid_win.width;  // image width and height, in pixels
    cinfo.image_height = vid_win.height;
    cinfo.input_components = 3;         // # of color components per pixel
    cinfo.in_color_space = JCS_RGB;     // colorspace of input image

    cinfo.smoothing_factor = GTK_ADJUSTMENT(page_jpeg.smooth_adj_jpeg)->value;
    if (GTK_TOGGLE_BUTTON(page_jpeg.optimize_jpeg)->active) {
      cinfo.optimize_coding = TRUE;
    }
    
    jpeg_set_defaults(&cinfo);
    jpeg_set_quality(&cinfo, GTK_ADJUSTMENT(page_jpeg.quality_adj_jpeg)->value, TRUE);
    jpeg_start_compress(&cinfo, TRUE);
    //row_stride = cinfo.input_components*vid_win.width; // JSAMPLE units per row
    row_stride=vid_win.width*3;
    while (cinfo.next_scanline < cinfo.image_height) {
      /* jpeg_write_scanlines expects an array of pointers to scanlines.
       * Here the array is only one element long, but you could pass
       * more than one scanline at a time if that's more convenient.
       */
      row_pointer[0] = &pic[cinfo.next_scanline * row_stride];
      jpeg_write_scanlines(&cinfo, row_pointer, 1);
    }
    jpeg_finish_compress(&cinfo);
    jpeg_destroy_compress(&cinfo);

    break;
  }

  fclose(outfile);
  if (!frozen)
    timeoutid = gtk_idle_add (grab, (gpointer) data);
  
  gtk_widget_destroy(widget->parent->parent->parent);
  return;
}

void save_cancel(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(widget->parent->parent->parent);
  if (!frozen)
    timeoutid = gtk_idle_add (grab, (gpointer) data);
  return;
}

void destroy( GtkWidget *widget,
	      gpointer   data )
{
  gtk_main_quit();
}

void save_dialog()
{
  GtkWidget *notebook;
  GtkWidget *window;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *vbox, *hbox;
  GtkObject *quality_adj_jpeg;

  if (!frozen)
    gtk_idle_remove(timeoutid);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show(vbox);
  
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  label = gtk_label_new("File");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  textbox = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), textbox, FALSE, FALSE, 2);
  gtk_widget_show(textbox);
  button = gtk_button_new_with_label("Browse...");
  gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (file_select), NULL);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
  gtk_widget_show(button);
  gtk_widget_show(hbox);

  notebook = gtk_notebook_new();
  gtk_box_pack_start(GTK_BOX(vbox), notebook, FALSE, FALSE, 2);
  gtk_widget_show(notebook);
  
  /* PPM PAGE */
  page_ppm.frame_ppm = gtk_frame_new("Save As");
  gtk_frame_set_shadow_type(GTK_FRAME(page_ppm.frame_ppm), GTK_SHADOW_NONE);
  gtk_widget_show(page_ppm.frame_ppm);

  page_ppm.vbox_ppm = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(page_ppm.frame_ppm), page_ppm.vbox_ppm);
  gtk_widget_show(page_ppm.vbox_ppm);

  page_ppm.radio_raw_ppm = gtk_radio_button_new_with_label(NULL, "Raw");
  gtk_box_pack_start(GTK_BOX(page_ppm.vbox_ppm), page_ppm.radio_raw_ppm, FALSE, FALSE, 2);
  gtk_widget_show(page_ppm.radio_raw_ppm);
  
  page_ppm.group_ppm = gtk_radio_button_group(GTK_RADIO_BUTTON(page_ppm.radio_raw_ppm));
  page_ppm.radio_ascii_ppm = gtk_radio_button_new_with_label(page_ppm.group_ppm, "ASCII");
  gtk_box_pack_start(GTK_BOX(page_ppm.vbox_ppm), page_ppm.radio_ascii_ppm, FALSE, FALSE, 2);
  gtk_widget_show(page_ppm.radio_ascii_ppm);

  page_ppm.label_ppm = gtk_label_new("PPM");
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), page_ppm.frame_ppm, page_ppm.label_ppm);

  /* JPEG PAGE */
  page_jpeg.frame_jpeg = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(page_jpeg.frame_jpeg), GTK_SHADOW_NONE);
  gtk_widget_show(page_jpeg.frame_jpeg);

  page_jpeg.vbox_jpeg = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(page_jpeg.frame_jpeg), page_jpeg.vbox_jpeg);
  gtk_widget_show(page_jpeg.vbox_jpeg);

  page_jpeg.table_jpeg = gtk_table_new(3, 3, TRUE);
  gtk_box_pack_start(GTK_BOX(page_jpeg.vbox_jpeg), page_jpeg.table_jpeg, FALSE, FALSE, 2);
  gtk_widget_show(page_jpeg.table_jpeg);

  page_jpeg.label_jpeg = gtk_label_new("Quality");
  gtk_table_attach_defaults(GTK_TABLE(page_jpeg.table_jpeg), page_jpeg.label_jpeg, 0, 1, 0, 1);
  gtk_widget_show(page_jpeg.label_jpeg);


  page_jpeg.quality_adj_jpeg = gtk_adjustment_new(75, 0, 100, 1, 10, 1);
  page_jpeg.quality_jpeg = gtk_hscale_new(GTK_ADJUSTMENT(page_jpeg.quality_adj_jpeg));
  gtk_scale_set_digits (GTK_SCALE(page_jpeg.quality_jpeg), 0);
  gtk_table_attach_defaults(GTK_TABLE(page_jpeg.table_jpeg), page_jpeg.quality_jpeg, 1, 3, 0, 1);
  gtk_widget_show(page_jpeg.quality_jpeg);


  page_jpeg.label_jpeg = gtk_label_new("Smoothness");
  gtk_table_attach_defaults(GTK_TABLE(page_jpeg.table_jpeg), page_jpeg.label_jpeg, 0, 1, 1, 2);
  gtk_widget_show(page_jpeg.label_jpeg);

  page_jpeg.smooth_adj_jpeg = gtk_adjustment_new( 0, 0, 100, 1, 10, 1 );
  page_jpeg.smooth_jpeg = gtk_hscale_new(GTK_ADJUSTMENT(page_jpeg.smooth_adj_jpeg));
  gtk_range_set_update_policy (GTK_RANGE(page_jpeg.smooth_jpeg), GTK_UPDATE_CONTINUOUS);
  gtk_scale_set_digits (GTK_SCALE(page_jpeg.smooth_jpeg), 0);
  gtk_scale_set_value_pos (GTK_SCALE(page_jpeg.smooth_jpeg), GTK_POS_TOP);
  gtk_scale_set_draw_value (GTK_SCALE(page_jpeg.smooth_jpeg), TRUE);
  gtk_table_attach_defaults(GTK_TABLE(page_jpeg.table_jpeg), page_jpeg.smooth_jpeg, 1, 3, 1, 2);
  gtk_widget_show(page_jpeg.smooth_jpeg);

  page_jpeg.optimize_jpeg = gtk_check_button_new_with_label("Optimize");
  gtk_table_attach_defaults(GTK_TABLE(page_jpeg.table_jpeg), page_jpeg.optimize_jpeg, 0, 1, 2, 3);
  gtk_widget_show(page_jpeg.optimize_jpeg);

  page_jpeg.label_jpeg = gtk_label_new("Jpeg");
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), page_jpeg.frame_jpeg, page_jpeg.label_jpeg);

  
/* END PAGES */
  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
  gtk_widget_show(hbox);
  button = gtk_button_new_with_label("Ok");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", save_ok, notebook);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 5);
  gtk_widget_show(button);
  button = gtk_button_new_with_label("Cancel");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", save_cancel, NULL);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 5);
  gtk_widget_show(button);
  
  gtk_widget_show(window);
  return;
}




