
/*
 *   IMPROV
 *
 *   by Michael Rudolph <rudolpml@hermes.informatik.uni-stuttgart.de>
 *   based on XFQCAM by Paul Chinn <loomer@svpal.org>
 *
 *   QuickCam code by Thomas Davis
 *   Additional QuickCam code Scott Laird <scott@laird.com>
 *   Adapted by Thomas Braunl, Uni Stuttgart, 1996
 *
 *   $Id: xfqcam.h,v 1.7 1996/07/04 12:08:52 rudolpml Exp $
 */

#if !defined(_XFGCAM_H)
#define _XFGCAM_H

#include "qcam.h"


#define FILE_README  "README"
#define IMAGE_SIZE (160*120)
#define MAX_AUTO_ADJUST  5
#define NO_OF_IMAGES 5
#define MAX_IPL_OPS  16
#define MODE_ADD 0
#define MODE_DEL 1


/*
 *    Image Processing Library Operations that may be performed on the
 *    images.
 */

typedef enum
{
    E_NOP,
    E_Identity,
    E_Negation,
    E_Dithering,
    E_Difference,
    E_Count,
    E_Threshold,
    E_NOP1,

    E_Min,
    E_Max,
    E_Mean,
    E_Median,
    E_Laplace,
    E_Sobel,
    E_Corner,
    E_NOP2,

    E_Erosion,
    E_Dilation,
    E_Open,
    E_Close,
    E_Fill,
    E_Connected,
    E_Boundary,
    E_Skeleton,
    E_NOP3,

    E_Noise,
    E_GrayStretch,
    E_GrayReduce,
    E_ShowXY,
    E_Overlay,
    E_Region,
    E_Circles
} E_IPLOP;


typedef struct _IPLOP
{
    E_IPLOP operation;
    double param[3];
} IPLOP;


extern IPLOP iplOps[NO_OF_IMAGES][MAX_IPL_OPS];
extern int iplCount[NO_OF_IMAGES];
extern int iplEditCount[NO_OF_IMAGES];


int QCAMinit();
int QCAMset(double thr, int con, int bri, int whi);
int QCAMget(BYTE rawbuf[], int * ret_chg, int * ret_quit);
int QCAMput(BYTE rawbuf[], int x);
int QCAMexit();
void QCAMSaveFile(const char * fileName);
void QCAMLoadFile(const char * fileName);



#endif
