/*
 *   Image Processing Library
 *   Thomas Braunl, Univ. Stuttgart, 1996
 *   Additional Code by Gerrit Heitsch
 *   Adapted by Michael Rudolph
 *   derived after Braunl et al. : Parallele Bildverarbeitung, Addison-Wesley
 *
 *   $Id: improc.h,v 1.6 1996/07/04 12:27:30 rudolpml Exp $
 *
 */

#if !defined(_IPL_IMPROC_H)
#define _IPL_IMPROC_H


#if defined (__cplusplus)
extern "C" {
#endif


#if !defined(_BYTE)
#define _BYTE
typedef unsigned char BYTE;
#endif

#if defined(IMPLEMENT_IPL)
#define MAX_IMAGE_SIZE (320*240)
#define MAX_CONTOUR  1000
#endif

#define ColWhite 255
#define ColBlack   0
#define GrayWhite 15
#define GrayBlack  0

/*
 *    image processing library configuration structure
 */

typedef struct
{
    int imageWidth;
    int imageHeight;
    int colorBlack;
    int colorWhite;
} IPL_CONFIG;


typedef struct
{
    short x;
    short y;
} IPLPoint;

typedef struct
{
    double x;
    double y;
} XYDistance;


/*
 *    Die global sichtbaren Funktionen der Image Processing Library
 *    Sie beginnen alle mit IPL_, um name clashes zu vermeiden.
 */

void IPL_init(IPL_CONFIG * config);

void IPL_col2gray(BYTE * imageIn, BYTE * imageOut);
void IPL_matchcol(BYTE * imageIn, BYTE * imageOut, BYTE r, BYTE g, BYTE b);

void IPL_laplace(BYTE * imageIn, BYTE * imageOut);
void IPL_sobel(BYTE * imageIn, BYTE * imageOut);
void IPL_mean(BYTE * imageIn, BYTE * imageOut);
void IPL_Cmean(BYTE * imageIn, BYTE * imageOut);

void IPL_threshold(BYTE * imageIn, BYTE * imageOut, BYTE threshold);
void IPL_gray_stretch(BYTE * imageIn, BYTE * imageOut);
void IPL_gray_reduce(BYTE * imageIn, BYTE * imageOut, int numvals);
void IPL_gen_histogram (BYTE * imageIn, int *histogram);
void IPL_equal_histogram (BYTE * imageIn, BYTE * imageOut, int *histogram);
void IPL_erosion (BYTE * imageIn, BYTE * imageOut, char * struc);
void IPL_dilation (BYTE * imageIn, BYTE * imageOut, char * struc);
void IPL_open (BYTE * imageIn, BYTE * imageOut, char * struc);
void IPL_close (BYTE * imageIn, BYTE * imageOut, char * struc);
void IPL_fill (BYTE * imageIn, BYTE * imageOut, int x, int y, char * struc);
void IPL_connected(BYTE * imageIn, BYTE * imageOut, int x, int y, char * struc);
void IPL_boundary(BYTE * imageIn, BYTE * imageOut, char * struc);
void IPL_skeleton(BYTE * imageIn, BYTE * imageOut, char * struc);
void IPL_identity(BYTE * imageIn, BYTE * imageOut);
void IPL_Cidentity(BYTE * imageIn, BYTE * imageOut);

int  IPL_contour(BYTE * imageIn, BYTE * imageOut, IPLPoint * result, BYTE threshold);
void IPL_median(BYTE * imageIn, BYTE * imageOut);
void IPL_min(BYTE * imageIn, BYTE * imageOut);
void IPL_max(BYTE * imageIn, BYTE * imageOut);
void IPL_negation(BYTE * imageIn, BYTE * imageOut);
void IPL_Cnegation(BYTE * imageIn, BYTE * imageOut);

void IPL_difference(BYTE * image1, BYTE * image2, BYTE * imageOut);
void IPL_Cdifference(BYTE * image1, BYTE * image2, BYTE * imageOut);

void IPL_noise(BYTE * imageIn, BYTE * imageOut, double noise);
void IPL_Cnoise(BYTE * imageIn, BYTE * imageOut, double noise);

int  IPL_count(BYTE * imageIn, BYTE * imageOut, BYTE val);
int  IPL_count_nobound(BYTE * imageIn, BYTE * imageOut, BYTE val);
void IPL_corner(BYTE * imageIn, BYTE * imageOut);
void IPL_and(BYTE *imageIn1, BYTE * imageIn2, BYTE *imageOut);
void IPL_or(BYTE *imageIn1, BYTE * imageIn2, BYTE *imageOut);
int  IPL_equal(BYTE *imageIn1, BYTE *imageIn2);
int  IPL_equal_nobound(BYTE *image1, BYTE *image2);
void IPL_showxy(BYTE *imageIn, BYTE *imageOut, int x, int y);
void IPL_Cshowxy(BYTE *imageIn, BYTE *imageOut, int x, int y);

void IPL_dither(BYTE *imageIn, BYTE *imageOut);
void IPL_overlay(BYTE *imageIn1, BYTE *imageIn2, BYTE *imageOut, BYTE gray_val);
void IPL_Coverlay(BYTE *imageIn1, BYTE *imageIn2, BYTE *imageOut, BYTE r, BYTE g, BYTE b);


void IPL_region_growing(BYTE *imageIn, BYTE *imageOut, int thresh);
int  IPL_FindCircles(BYTE * imageIn, BYTE * imageOut, XYDistance * result);
void IPL_TestPalette(BYTE * imageOut);

void IPL_HSVValue(BYTE *imageIn, BYTE *imageOut);

void rgbToHsv(double r, double g, double b, double *h, double *s, double *v);

#if defined (__cplusplus)
}
#endif



#endif
