
/*
 *    QuickCam
 *    --------
 *
 *    QuickCam code by Thomas Davis
 *    Additional QuickCam code Scott Laird <scott@laird.com>
 *    Polished and cleaned up by Michael Rudolph 
 *
 *    $Id: qcam.h,v 1.2 1996/06/12 15:41:55 rudolpml Exp $
 */

#if !defined (_QCAM_H)
#define _QCAM_H


#if defined(__cplusplus)
extern "C" {
#endif

#if !defined(_BYTE)
#define _BYTE
typedef unsigned char BYTE;
#endif


#if defined(_IMPLEMENT_QCAM)

#define QC_BRIGHTNESS	0x0b
#define QC_CONTRAST	0x19
#define QC_WHITEBALANCE	0x1f
#define QC_XFERMODE	0x07
#define QC_XSIZE	0x13
#define QC_YSIZE	0x11
#define QC_UNK1		0x0d
#define QC_UNK2		0x0f
#define MAX_AUTO_ADJUST 15
#define FILE_QCAM       "/tmp/quickcam"
#define QC_SENDSTATUS	41

#endif

/*
 *    structure definition of quick cam configuration paramters
 */

typedef struct _QC_CONFIG
{
  int quickcam_port;
  int colour;
  int brightness;
  int whitebalance;
  int blackbalance;
  int contrast;
  int saturation;
  int hue;
  int unk1;
  int unk2;
  int bpp6;
  int biMode;
  int canDoBi;
  int zoom;
  int xfermode;
  int speed;
  int debugFlag;
  int xsize;
  int ysize;
  double thresh;
} QC_CONFIG;


/*
 *    library function prototypes
 */

int  QC_find(void);
void QC_reset(int port);
int  QC_waitfor_bi(int port);
int  QC_getversion(int port, int *col, int *cam, int *con);
int  QC_getstatus(int port);
int  QC_sendbyte(int port, int value);
int  QC_sendcmd(int cmd, int value);
void QC_set_brightness();
void QC_set_size();
void QC_set_contrast();
void QC_set_whitebalance();
void QC_set_all();
void QC_Get4bppImageUni(BYTE * buffer);
void QC_CGet4bppImageUni(BYTE * buffer);
int  QC_init();
void QC_exit();


extern QC_CONFIG _QCConfig;

#if defined(__cplusplus)
}
#endif


#endif
