#ifndef vcamFrame_H
#define vcamFrame_H

/* Vision VV6300 CMOS camera frame routines interface
 * fileName: vcamFrame.h
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 * history: v0.0 (Feb 1999) - frame processing functions
 * notes:
 * bugs:
 */

/**********************************************************/

#include "globalDefines.h"

/** QCK (00001000): (SR) pixel sample clock. */
#define QCK 0x08 /* look at OSReadParSR() doc before changing */
/** FST (00010000): (SR) Frame start signal.*/
#define FST 0x10
/** SIN (00000100): (CTRL) Frame timing reset. */
#define SIN 0x04

#define QCK_WAITS 100
#define NO_QCK_FOUND 0
#define QCK_FOUND 1
#define QCK_SLOW 1

#define WRITE_FILE 0

#define IMAGE_X 160
#define IMAGE_Y 120
#define PIXELS_PER_LINE 80
#define LINES 60

/**********************************************************/

/** Get a visible frame
  * @param visible: Location to write frame to
  */
int getVisibleFrame ( BYTE* visible );

/**********************************************************/

/** Convert visible frame to ximage
  * @param visible: Pointer to visible frame (from getVisibleFrame)
  * @param ximage: Location to write ximage to
  */
int visibleToRGB ( BYTE* visible, BYTE* rgbImage );

/**********************************************************/

/** Get a byte of data from the camera */
BYTE getPixel ( void );

/**********************************************************/

int FST_read ( void );

/**********************************************************/

int testForQCK ( void );

/**********************************************************/

#endif /* vcamFrame_H */

