
/*
 *   IMPROV
 *
 *   by Michael Rudolph <rudolpml@hermes.informatik.uni-stuttgart.de>
 *   based on XFCAM by Paul Chinn <loomer@svpal.org>
 *
 *   QuickCam code by Thomas Davis
 *   Additional QuickCam code Scott Laird <scott@laird.com>
 *   Adapted by Thomas Braunl, Uni Stuttgart, 1996
 *
 *   $Id: xfqcam.h,v 1.7 1996/07/04 12:08:52 rudolpml Exp $
 */

#if !defined(_XFGCAM_H)
#define _XFGCAM_H

#include "qcam.h"


#define FILE_README  "README"
#define IMAGE_SIZE (160*120)
#define CIMAGE_SIZE (3*IMAGE_SIZE)
#define MAX_AUTO_ADJUST  5
#define NO_OF_IMAGES 5
#define MAX_IPL_OPS  16
#define MODE_ADD 0
#define MODE_DEL 1

/*
 *    Image Processing Library Operations that may be performed on the
 *    images.
 */

typedef enum
{
  /* IP functions */
  E_NOP = 1,
  E_Identity,
  E_Negation,
  E_Dithering,
  E_Difference,
  E_Count,
  E_Threshold,
  /*  E_NOP1,*/
  
  E_ColGray,
  E_MatchCol,
  E_HSV,
  /*  E_NOP2,*/
  
  E_Min,
  E_Max,
  E_Mean,
  E_Median,
  E_Laplace,
  E_Sobel,
  E_Corner,
  /*  E_NOP3,*/

  E_Erosion,
  E_Dilation,
  E_Open,
  E_Close,
  E_Fill,
  E_Connected,
  E_Boundary,
  E_Skeleton,
  /*  E_NOP4,*/
  
  E_Noise,
  E_GrayStretch,
  E_GrayReduce,
  E_ShowXY,
  E_Overlay,
  E_TestPalette,
  E_Region,
  E_Circles,
  
  /* Menu headings */
  M_General,
  M_Format,
  M_Morphology,
  M_Edges,
  M_Colour,
  M_Advanced
} E_IPLOP;

typedef struct {
  char *name;
  E_IPLOP ref;
  int args;
} MenuItemDetails;

typedef struct _IPLOP
{
  E_IPLOP operation;
  double param[3];
} IPLOP;

typedef struct {
  char *name;
  int args;
} MenuNameArg;

extern IPLOP iplOps[NO_OF_IMAGES][MAX_IPL_OPS];
extern int iplCount[NO_OF_IMAGES];
extern int iplEditCount[NO_OF_IMAGES];

/* init vv6300 */
int VInit ( int* colCam );
/* init Quickcam */
int QInit ( int *colCam, int *camVer, int *conVer );

int CAMinit(int *colCam, int *camVer, int *conVer);
int CAMset(double thr, int con, int bri, int whi);
int CAMget(BYTE rawbuf[], int * ret_chg, int * ret_quit, int col);
int CAMput(BYTE rawbuf[], int x, int col);
int CAMexit();
void CAMSaveFile(const char * fileName);
void CAMLoadFile(const char * fileName);



#endif




