/* pc_io.c */
#include "pc_io.h"
#include <asm/io.h>
#include <stdio.h>

/**********************************************************/

BYTE OSReadParData ( void )
	{
	BYTE b;
	b = OSReadParCTRL ();
	OSWriteParCTRL ( b | IO_BIT );
	return (inb ( PAR_DATA ));
	}

/**********************************************************/

BYTE OSReadParSR ( void )
	{
	/* match the robios calls:
	busy = bit 4,
	ack = bit 3,
	pe = bit 2,
	slct = bit 1,
	errot = bit 0
	*/

	BYTE b=0;
	b = inb ( PAR_SR );
	/* switch bit 7 (busy) because it is active low */
	b ^= 0x80;
	b >>= 3;
	return b;
	}

/**********************************************************/

BYTE OSReadParCTRL ( void )
	{
	/* match the robios calls:
	slctin = bit 3,
	int = bit 2,
	autofdxt = bit 1,
	strobe = bit 0
	*/
	BYTE b=0;
	b = inb ( PAR_CTRL );
	/* init pin is active-high -> change it temporarily */
	b ^= 0x04;
	/* mall all active high finally */
	b = ~b;
	/* only return the 4 pinstates */
	b &= 0x0f;

	return (b);
	}

/**********************************************************/

void OSWriteParCTRL ( BYTE b )
	{
	/* make all active low */
	b = ~b;
	/* except INIT pin */
	b ^= 0x04;

	outb ( b, PAR_CTRL );
	}

/**********************************************************/
BYTE DRead ( void )
	{ return inb ( PAR_CTRL ); }

/**********************************************************/

void DWrite ( BYTE b )
	{ outb ( b, PAR_CTRL ); }

/**********************************************************/

