#ifndef PC_IO_H
#define PC_IO_H
/** description: pc_io.c is a pc implementation of some basic robios functions
	for reading from and writing to the parallel port.

	The actual prototypes for these functions are in robios. 
	librobi/io.h (the actual source is in dig_io.s)

	author: Jesse Pepper (peppe-jj@ee.uwa.edu.au)
	creation date: 25 January 1999
	last modified: 27 January 1999

	version history:
	1.0: Original version
*/

#include "globalDefines.h"
#include <sys/io.h>

/**********************************************************/

BYTE OSReadParCTRL ( void );

/**********************************************************/

void OSWriteParCTRL ( BYTE );

/**********************************************************/

BYTE OSReadParSR ( void );

/**********************************************************/

BYTE OSReadParData ( void );

/**********************************************************/

BYTE DRead ( void );

/**********************************************************/

void DWrite ( BYTE b );

/** I/O bit is bit 5 of CTRL register, when 0 -> data lines in output mode,
	1 -> data lines in input mode */
#define IO_BIT 0x20
#define PC_PARALLEL_PORT 0x378
/* 0x378 is the right address for ceres */
/* 0x278 or 0x378 or 0x3bc */
#define PAR_DATA PC_PARALLEL_PORT
/* not sure about these below either */
#define PAR_SR (PC_PARALLEL_PORT + 1)
#define PAR_CTRL (PC_PARALLEL_PORT + 2)

#endif

