/* Vision VV6300 CMOS camera implementation
 * fileName: vcam.c
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 */

#include "vcam.h"
#include "vcamInit.h"
#include "vcamFrame.h"
#include <stdio.h>

int VC_Init ( void )
	{
	if (init () == VV6300)
		return (VV6300);
	else
		{
		if (init () != VV6300)
			return (NO_CAMERA);
		else
			return (VV6300);
		}
	}

void VC_CGet24bppImage ( BYTE* rgbImage )
	{
	/* Pre-condition: ximage is a pointer to XIMAGE_SIZE bytes */

	BYTE visible[VISIBLE_SIZE];
	
	while ( getVisibleFrame ( visible ) != 0 )
		fprintf ( stderr, "bad frame\n" ); /* wait until we get a clean frame */
	
	visibleToRGB ( visible, rgbImage );
	}

