#ifndef vcamInit_H
#define vcamInit_H

/* VV6300 CMOS camera initialisation routines
 * fileName: vcamInit.h
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 * history: v0.0 - Basic initialisation (very basic)
 * notes: There is some problem with the camera not initialising after certain
 * messages are sent to it. We just skip these initialisations
 * bugs:
 */

/*********************************************************/

#include "vcam.h"

/*********************************************************/

/* Define this as 1 for debugging the initialisation routines */
#define DEBUG_INIT 0
#define DEBUG 0
/** @name Serial initialization data */
/*@{*/ 
/** Write data byte (see under section labled 'Serial Interface' in the camera
    specification document). */ 
#define WRITE  	0X20 	

/** The address of the camera (with the read bit switched on). */
#define READ  	0X21

/** The address of the Setup 0 register in the VV 6300.  This register needs
    to be accessed in order to set the camera to 8 wire parallel output mode.*/
#define SETUP_0 0x10
/** The address of the Setup 4 register in the VV 6300.  This register needs
	to be accessed in order to set the QCK in free running mode and enable FST. */
#define SETUP_1 0x11
#define SETUP_4 0x14
/** The address of the Clock Divisor register.  This register need to be 
    accessed in order to change the clock divisor value.*/
#define CLK_DIV	0X25
/*@}*/ 


#define WAIT_FOR_ACK 1
#define NO_WAIT_FOR_ACK 0
#define ACK_WAITS 20

#define SCL 0x01
/** SDA (00001000): (CTRL) Serial bus data. */
#define SDA 0x08


/*********************************************************/

/** Initialse the VV6300 camera */
int init ( void );

/*********************************************************/

/** Send initialisation and setup data to the VV6300
  * @param index: The register to send data to
  * @param data: The data to send
  * @param waitAcknowledge: Instructs whether to wait for acknowledge
  * see note above. Valid values are:
  * 	WAIT_FOR_ACK
  * 	NO_WAIT_FOR_ACK
  */
void writeMessage ( BYTE index, BYTE data, BYTE waitAcknowledge );

/*********************************************************/

/** Generate the start condition signifying the start of a serial message
  */
void startCondition ( void );

/*********************************************************/

/** Generate the stop condition signifying the end of a serial message
  */
void stopCondition ( void );

/*********************************************************/

/** Send a byte of data serially
  * @param value: The byte to send
  * @param waitAcknowledge: Wait for acknowledge of byte?
  * valid values are:
  * 	WAIT_FOR_ACK
  * 	NO_WAIT_FOR_ACK
  */
void sendByte ( BYTE value, BYTE waitAcknowledge );

/*********************************************************/

/** Bring the SDA (serial data) pin low */
void SDA_clear ( void );

/*********************************************************/

/** Bring the SDA pin high. Note: Extreme care should be
  * taken not to drive the SDA pin high when the camera is
  * acknowledging (driving SDA low)
  */
void SDA_set ( void );

/*********************************************************/

/** Read the value of the SDA pin */
int SDA_read ( void );

/*********************************************************/

/** Bring the SCL (serial clock) pin low */
void SCL_clear ( void );

/*********************************************************/

/** Bring the SCL (serial clock) pin high */
void SCL_set ( void );

/*********************************************************/

/** Debugging function to print out a byte in 1's and 0's
  */
void printByte ( BYTE b );

/*********************************************************/

/** Wait for approximately 70 ns */
void wait ( void );

/*********************************************************/

/** test for the VV6300 camera */
int testForCam ( void );

/*********************************************************/

#endif
