#if defined(__cplusplus)
extern "C" { 
#endif
  
#ifndef LABSCALE_H
#define LABSCALE_H

/**********************************************************************/
/* cut out & scaling an Image                                         */
/* _int types are same as the others, but return just an int as       */
/* Successflag and use integer values as internal measurementunits    */
/* since the float algorithms seem to produce memory problems on some */
/* Machines. IT IS RECOMMENDET TO SWITCH TO THE _INT VERSIONS!!!!!    */
/*                                                                    */
/* Input:       imagedata                                             */
/*              Formats: MONO: YYYYYY, RGB: RGBRGBRGB, TIP: BGROBGROBG*/
/*                       MATROX: RRRRR...GGGGG...BBBBBB               */
/*              old images width and height                           */
/*              crop-Startpoint in old Image                          */
/*              crop Width and height in old Image                    */
/*              destination Data (has to be allocated beforehand)     */
/*              widht and height of destinationimage after Scaling    */
/* Output:      Success (destdata)                                    */
/* Sideeffects: contents of destdatapointer are changed               */
/**********************************************************************/

/**********************************************************************/
/* cut out & subsample an Image                                       */
/* if subsamplefactor is positive as many Pixels in that direction are*/
/* summed up and the mean taken as one new Pixel                      */
/* if subsamplefactor is negative the new Image has as many pixels of */
/* the same Value in that direction                                   */
/* the values can be mixed freely, but 0 is forbidden, returning an   */
/* 0 and not changing the datapointer                                 */
/* for adjusting width and height of the Image see subsampleImage in  */
/* labImage.c                                                         */
/*                                                                    */
/* Input:       imagedata Formats: MONO: YYYYYY, RGB: RGBRGBRGB       */
/*              old images width and height                           */
/*              crop-Startpoint in old Image                          */
/*              crop Width and height in old Image                    */
/*              destination Data (has to be allocated beforehand)     */
/*              smaplefactors in x and y direction                    */
/* Output:      Success                                               */
/* Sideeffects: contents of destdatapointer are changed               */
/**********************************************************************/

unsigned char *scaleMONO(unsigned char *imageData, int imageW, 
  int imageH, int sourceX, int sourceY, int sourceW, int sourceH,
  unsigned char *destData, int destW, int destH);

unsigned char *scaleRGB(unsigned char *imageData, int imageW, 
   int imageH, int sourceX, int sourceY, int sourceW, int sourceH,
  unsigned char *destData, int destW, int destH);

int scaleMONO_int( unsigned char *imageData, int imageW, int imageH, 
                   int sourceX, int sourceY, int sourceW, int sourceH,
                     unsigned char *destData, int destW, int destH);
int scaleRGB_int( unsigned char *imageData, int imageW, int imageH, 
                   int sourceX, int sourceY, int sourceW, int sourceH,
                         unsigned char *destData, int destW, int destH);

int subsample_mono(unsigned char *p_image, int imageW, int imageH, 
              int sourceX, int sourceY, int sourceW, int sourceH,
              unsigned char *p_destData, int samplefactorx, 
              int samplefactory);

int subsample_rgb(unsigned char *p_image, int imageW, int imageH, 
              int sourceX, int sourceY, int sourceW, int sourceH,
              unsigned char *p_destData, int samplefactorx, 
              int samplefactory);

#if defined(__cplusplus)
}
#endif

#endif /* LABSCALE_H */
