#ifndef ImprovMain_h
#define ImprovMain_h

#include <FL/Fl.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Browser.H>
#include <FL/fl_file_chooser.H>
#include <FL/Fl_Multiline_Output.H>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "ImprovUI.h"
#include "CamImage.h"
#include "ProcImage.h"

#include "ImprovWrapper.h"

#define IMPROV_MAGIC_NUMBER 0x5652504d    // magic number for config file 'MPRV'

//Maximum Number of windows
#ifndef _max
#define MAX_WINDOWS 5
#endif

void set_window_cb(Fl_Widget *w, void *param);
void param_cb(Fl_Widget *w, void *param);
void cam_param_cb(Fl_Widget *w, void *param);
void update_param_cb(double p[]);
void quit_cb(Fl_Widget *w, void *param);
void help_cb(Fl_Widget *w, void *param);
void about_cb(Fl_Widget *w, void *param);
void enlarge_cb(Fl_Widget *w, void *param);
void auto_cb(Fl_Widget *w, void *param);
void stop_cb(Fl_Widget *w, void *param);
void save_img_cb(Fl_Widget *w, void *param);
void save_cfg_cb(Fl_Widget *w, void *param);
void load_cfg_cb(Fl_Widget *w, void *param);
void timer_cb(void *);
void idle_cb(void *);

static const char * const helpText[] = {
  "IMPROV - Help File",
  " ",
  " ",
  "1. IMPROV - Image Processing for Robot Vision",
  " ",
  "IMPROV is a simple tool to test image processing functions.",
  "Images are taken from the QUICKCAM, Video for Linux device or", 
  "Video for Linux II device. Operations may be concatenated, so",
  "even a more complex task can also be tested. The original image"
  "(from live camera or loaded sequence) is shown in window #1.",
  " ",
  "2. Selecting and adding image processing operations",
  " ",
  "The dropchoice on top of each image allows for the selection of",
  "an image processing operation to be performed on the previous image",
  "and displayed in the current image window.",
  "The chosen operation is displayed in a browser control below the",
  "image window. Multiple operations can be successively applied by",
  "concatenating them pushing the '+' button to the left of the browser.",
  "As long as the operation is not appended to the existing list of",
  "operations it may be replaced by some other selection from the dropchoice.",
  "Some operations take arguments like the threshold function. Up to six",
  "paramters can be set using the slider controls labeld P1 to P6.",
  "Parameter values are in the range [0.0..1.0]",
  " ",
  " ",
  "3. Modifying and deleting image processing operations",
  " ",
  "Changes of the parameter slider controls are effective for the most",
  "recent selected image processing operation. Parameters can be changed",
  "afterwards by first selecting them in the corresponding browser and then",
  "adjusting the parameter slider. A selected operation gets highlighted the",
  "'+' push button changes into a '-' push button. Pressing it will remove the",
  "operation from the list.",
  " ",
  "4. The image processing operations",
  " ",
  "Here is a brief summary of the image processing operations available",
  "in IMPROV.",
  " ",
  "General:",
  " Identity       Copy source image to target image",
  " Camera         Display the actual camera image",
  " Negation       Negate image",
  " Difference     Difference image of source and previous source",
  " Noise          Generate Noise in target image (P1=degree of noise)",
  " Threshold      Binarize image. Threshold is given by P1", 
  " Show (x,y)     Print grey/color value of pixel at (x=P1,y=P2)",
  " ",
  "Format:",
  " Col. to Gray   Convert color image to gray scale",
  " RGB to HSV     Convert RGB to HSV",
  " Grey bin(T).   Binarize picture(Threshold=P1)",
  " Grey dither    Target image contains only black/white pixels",
  " Grey stretch   Make use of all grey values",
  " Grey reduce    Reduce the number of grey values",
  " ",
  "Morphology:",
  " Erosion        3x3 Erosion",
  " Dilation       3x3 Dilation",
  " Open           3x3 Erosion and then Dilation",
  " Close          3x3 Dilation and the Erosion",
  " Fill           3x3 Fill operation",
  " Connected      3x3 Connected operation",
  " Boundary       3x3 Boundary operation",
  " Skeleton       3x3 Skeleton operation",
  " ",
  "Edges:",
  " Minimum        3x3 Minimum Filter",
  " Maximum        3x3 Maximum Filter",
  " Mean           3x3 Mean Filter",
  " Median         3x3 Median Filter",
  " Laplace        3x3 Laplace Filter",
  " Sobel          3x3 Sobel Filter (absolute gradient value)",
  " Corner         3x3 Corner Filter",
  " ",
  "Advanced:",
  " Region (t)     Segmentation (t=P1 as threshold)",
  " Contour        Build contour picture in Chain Code",
  " Moravec        Moravec interest operator",
  " Track",
  " Histo. Equi.   Histogram equallization",
  " Gaus.  smooth  Gaussian smoothing",
  " Match Color    Select RGB color with slide rulers to match image",
  " ",
  "Motion:",
  " OF - Corr.     Correlation based optical flow algorithm",
  " OF - Diff.     Differential based optical flow algorithm",
  " ",
  "5. Links",
  " ",
  "IMPROV - Image Processing for Robot Vision",
  "http://www.ee.uwa.edu.au/~braunl/improv/",
  "http://robotics.ee.uwa.edu.au/improv/",
  " ",
  NULL
};

static const char * const aboutText[] = {
  " ",
  "@c@m@bIMPROV - Image Processing for Robot Vision",
  "@c@iSee it live at the IMPROV !",
  "@c@i@bversion 4.1, Jan. 2001",
  " ",
  "@c V4.1 by Thomas Brunl <braunl@ee.uwa.edu.au>",
  "@c V4.0 by Thomas Brunl, Uli Mezger, Paul McAlpine <uli@ei.tum.de>",
  "@c V1.0 by Thomas Brunl and Michael Rudolph",
  "@ccolor by Thomas Braunl and Elliot Nicholls <nicho-ej@ee.uwa.edu.au>",
  "@cparts of the IPL by Gerrit Heitsch <heitscgt@informatik.uni-stuttgart.de>",
  "@cThe Univ. of Western Australia, E&E Eng., CIIPS 2001",
  "@cusing XFQCam and QuickCam code by Paul Chinn <loomer@1000klub.com>",
  "@cThomas Davis and Scott Laird <scott@laird.com>",
  "@cwith additions and modifications by Paul Chinn",
  "@cpatch for 16bpp displays by Brian Beaudoin <baddog@darkknight.net>",
  " ",
  " ",
  "@chttp://www.ee.uwa.edu.au/~braunl/improv",
  " ",
  "@cThis program is free for noncommercial use.",
  NULL};

#endif // ImprovMain_h



