#include "ImprovUI.h"

ImprovUI::ImprovUI(int nr_of_windows, IPL_CONFIG *ipl_config ) 
{
  int x_pos,y_pos;
  int width1,height1;
  int image_box_width=420;
  int image_box_height=315;//310;
  int image_box_posx=145;
  int image_box_posy=90;

  Fl_Window* w;
  { 
    Fl_Double_Window* o = main_window = new Fl_Double_Window(726, 500, 
		      "IMPROV - Image Processing for Robot Vision");
    w = o;
    o->user_data((void*)(this));
    { 
      //Fl_Box* o = image_box = new Fl_Box(145, 90, 565, 400);
      Fl_Box* o = image_box = new Fl_Box(image_box_posx, 
					 image_box_posy,
					 image_box_posx+image_box_width, 
					 image_box_posy+image_box_height);
      o->box(FL_ENGRAVED_BOX);
    }
    
    //Set Displays    
    if(nr_of_windows==1)
      { 
	width1=260;
        height1=360;           
	
	x_pos=160;
	y_pos=105;
      }
    else if(nr_of_windows==3)
      {
	width1=260;
	height1=185;
	
	x_pos=160;
	y_pos=105;
      
      }
    else
      {
	width1=175;
	height1=185;
	
	x_pos=160;
        y_pos=105;
      }
    
    {
      CamImage* o = image1 = new CamImage(x_pos, y_pos, 
					  width1,
					  height1,
					  "Camera");
      o->end();
    }
    
    // Set Display windows
    int x_akt=x_pos;int y_akt=y_pos; int stepx=5, stepy=10;
    for(int k=0; k<nr_of_windows; k++)
    { 
      x_akt+=width1+stepx;
      if(x_akt > 530)
      {
	x_akt=160;
	y_akt+=height1+stepy;
      }
      
      ProcImage* o = image2[k] = new ProcImage(x_akt, y_akt, 
					       width1, 
					       height1, 
					       "Image:" );
      o->end();
      
    }
    
    { Fl_Light_Button* o = button_autobrightness = new Fl_Light_Button(470, 15, 80, 20, "AutoBrightness");
      o->labelsize(8);
      //o->deactivate();
      o->callback((Fl_Callback*)auto_cb);
    }
    { Fl_Light_Button* o = button_enlarge = new Fl_Light_Button(470, 35, 80, 20, "Orig. Size");
      o->labelsize(12);  
      o->value(0);
      o->callback((Fl_Callback*)enlarge_cb);
      //o->deactivate();
    }
    { Fl_Light_Button* o = button_stop = new Fl_Light_Button(470, 55, 80, 20, "Stop");
      o->labelsize(12);
      o->callback((Fl_Callback*)stop_cb);
    }
    { Fl_Button* o = button_save_img = new Fl_Button(550, 15, 80, 20, "Save Image");
      o->labelsize(12);
      o->callback((Fl_Callback*)save_img_cb);
    }
    { 
      Fl_Button* o = button_about = new Fl_Button(550, 35, 80, 20, "About");
      o->labelsize(12);
      o->callback((Fl_Callback*)about_cb);
    }
    { 
      Fl_Button* o = button_help = new Fl_Button(550, 55, 80, 20, "Help");
      o->labelsize(12);
      o->callback((Fl_Callback*)help_cb);
    }
    { Fl_Button* o = button_save_cfg = new Fl_Button(630, 15, 80, 20, "Save Config");
      o->labelsize(12);
      o->callback((Fl_Callback*)save_cfg_cb);
    }
    { Fl_Button* o = button_load_cfg = new Fl_Button(630, 35, 80, 20, "Load Config");
    o->labelsize(12);
    o->callback((Fl_Callback*)load_cfg_cb);
    }
    { Fl_Button* o = button_quit = new Fl_Button(630, 55, 80, 20, "Quit");
    o->labelsize(12);
      o->callback((Fl_Callback*)quit_cb);
    }
    { Fl_Box* o = box_title = new Fl_Box(270, 15, 145, 25, "IMPROV " VERSION);
      o->labeltype(FL_SHADOW_LABEL);
      o->labelfont(3);
      o->labelsize(24);
    }
    { Fl_Box* o = box_subtitle = new Fl_Box(240, 45, 210, 20, "Image Processing for Robot Vision");
      o->labelfont(3);
      o->labelsize(12);
    }
    { 
      Fl_Value_Slider* o = p4 = 
	new Fl_Value_Slider(35, 90, 25, 130, "Bri.");
      o->type(4);
      o->labelsize(10);
      o->maximum(255);
      o->step(1);
      o->value(125); 
      o->callback((Fl_Callback*)cam_param_cb);
      o->align(FL_ALIGN_TOP); 
    }
    { 
      Fl_Value_Slider* o = p5 = 
	new Fl_Value_Slider(60, 90, 25, 130, "Contr.");
      o->type(4);
      o->labelsize(10); 
      o->maximum(120);
      o->step(1);
      o->value(60);
      o->callback((Fl_Callback*)cam_param_cb);
      o->align(FL_ALIGN_TOP);
    }
    { 
      Fl_Value_Slider* o = p6 = 
	new Fl_Value_Slider(85, 90, 25, 130, "Sat.");
      o->type(4);
      o->labelsize(10);
      o->maximum(120);
      o->step(1);
      o->value(60); 
      o->callback((Fl_Callback*)cam_param_cb);
      o->align(FL_ALIGN_TOP);
    }
    { 
      Fl_Value_Slider* o = p1 = new Fl_Value_Slider(35, 260, 25, 130, "P1");
      o->type(4);
      o->labelsize(10);
      o->value(0.5);
      o->callback((Fl_Callback*)param_cb);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Value_Slider* o = p2 = new Fl_Value_Slider(60, 260, 25, 130, "P2");
      o->type(4);
      o->labelsize(10);
      o->value(0.5);
      o->callback((Fl_Callback*)param_cb);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Value_Slider* o = p3 = new Fl_Value_Slider(85, 260, 25, 130, "P3");
      o->type(4);
      o->labelsize(10);
      o->value(0.5);
      o->callback((Fl_Callback*)param_cb);
      o->align(FL_ALIGN_TOP);
    }
    { 
      Fl_Output* o = text_info = new Fl_Output(15, 415, 115, 75, "Text Window");
      o->type(4);
      o->labelsize(12);
      o->textsize(10);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Box* o = dimensions = new Fl_Box(35, 15, 75, 20, "80 x 60");
      o->box(FL_ENGRAVED_BOX);
      o->labelsize(10);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = rate = new Fl_Box(110, 15, 75, 20, "Rate: 3.75 fps");
      o->box(FL_ENGRAVED_BOX);
      o->labelsize(10);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = bpp = new Fl_Box(35, 35, 75, 20, "8 bpp");
      o->box(FL_ENGRAVED_BOX);
      o->labelsize(10);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = rate_change = new Fl_Box(110, 35, 75, 20, "Change: 2.18");
      o->box(FL_ENGRAVED_BOX);
      o->labelsize(10);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }

    /*
    {
      Fl_Group* o = new Fl_Group(143, 63, 81, 27 );
      o->box(FL_NO_BOX);
      
      { Fl_Check_Button* o = window2=new Fl_Check_Button(145, 65, 25, 25, "2");
      o->type(102);
      o->down_box(FL_DIAMOND_UP_BOX); 
      o->callback((Fl_Callback*)set_window_cb);
      o->deactivate();
      }                     
    
      { Fl_Check_Button* o = window4=new Fl_Check_Button(172, 65, 25, 25, "4");
      o->type(102);
      o->down_box(FL_DIAMOND_UP_BOX); 
      o->callback((Fl_Callback*)set_window_cb); 
      o->deactivate();
      } 
      
      { Fl_Check_Button* o = window6=new Fl_Check_Button(199, 65, 25, 25, "6");
      o->type(102);
      o->down_box(FL_DIAMOND_UP_BOX);
      o->callback((Fl_Callback*)set_window_cb);   
      o->deactivate();               
      }   
      o->callback((Fl_Callback*)set_window_cb);  
    }
    */

    o->end();
  }
}

void ImprovUI::show() 
{
  main_window->show();
}


