#ifndef __v4l2_camera_h
#define __v4l2_camera_h

#ifdef HAVE_V4L2

#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>

#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>

#include "Camera.h"
#include "FW/labImage.h"

#define DEFAULT_VIDEO_DEVICE  "/dev/video"
#define VIDEO_STANDARD        "PAL"
#define DEFAULT_IMAGE_WIDTH   160
#define DEFAULT_IMAGE_HEIGHT  120
#define STREAMBUFS            4

class V4L2Camera : public Camera {
  struct {
    v4l2_buffer vidbuf;
    char *data;
  } vimage[STREAMBUFS];      // buffers for images
  
  int vid_fd;                    // video device
  
  struct v4l2_format fmt;        // video format request
  
  int pic_size_x;
  int pic_size_y;
  int pic_size;

  int x_offset;
  int y_offset;
  
 public:
   virtual bool  open(IPL_CONFIG *ipl_config);
   virtual void  close(void);
   virtual void  read(Picture *p_frame);
   virtual void  params(double p[]);
   virtual bool  iscolor(void);
   virtual void  get_info(CamInfo *info); 
   virtual bool  get_IPL(IPL_CONFIG *ipl_config);
   virtual int   map_to_v4l2_format(pixel_format format);
};

  extern V4L2Camera v4l2camera;

#endif /* HAVE_V4L2 */

#endif /* __v4l2_camera_h */


