#ifndef CamImage_h
#define CamImage_h
#include <FL/Fl.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>

#include <FL/Fl_Image.H>

#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Menu_Item.H>

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "Camera.h"
#include "ImprovWrapper.h"

class CamImage : public Fl_Group {
  Fl_Menu_Button *menu;
  Fl_Box *box;
  
  Picture *p_output_img;
  
  bool cam_colour;                   // true if camera is colour

  bool initialised;                  // flag for validation
  
  bool stopped; 
  
  bool enlarge;                    // true if enlarge enabled
  
  Camera *camera;                    // camera implementation used
  
 public:
  CamImage(int x, int y, int w, int h, const char *label=0);
  ~CamImage();
  
  void initialize(Picture *p_out, bool *colour);
  
  static void menu_cb(Fl_Widget *w, void *param);
  
  void camera_stopped(bool state);
  
  void enable_enlarge();
  void disable_enlarge();
  void save_image(char *fname);
  void get_cam_info(CamInfo *info);
  void get_IPL_info();
  void set_params(double p[]);
 private:
  void draw();
  void init_menu();
};

#endif // CamImage_h





