#ifndef Camera_h
#define Camera_h

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "ImprovWrapper.h"
#include "FW/labImage.h"

#define DEFAULT_BLACK 0
#define DEFAULT_WHITE 255
#define DEFAULT_WIDTH 82
#define DEFAULT_HEIGHT 62

#define DEFAULT_BPP 24       

#define MAXSEQLEN     1000  /* max images per sequence   */ 
#define MAXSEQNAMELEN  100  /* max char per seq filename */ 
#define MAXSOURCE      200  /* max char n source info    */ 

typedef unsigned char BYTE;

// Information on the camera's attributes
typedef struct {
    int width;   // width of image, including border
    int height;  // height of image, including border
    int bpp;     // colour depth (bits per pixel)
} CamInfo;

extern IPL_CONFIG ipl_config;
extern int frame_count;

extern void colour_scan(void *, int, int, int, BYTE *);
extern void grey_scan(void *, int, int, int, BYTE *);

class Camera {
 public:
  // Return true on success and false if camera is unsupported on this machine
  virtual bool open(IPL_CONFIG *ipl_config) = 0;

  // Releases camera.  Must be called if open succeded.
  virtual void close(void) = 0;

  // Fetch next frame from camera
  virtual void read(Picture *p_frame) = 0;

  // Does this camera return color or grey scale images
  virtual bool iscolor(void) { return false; };

  // Get information on image width, height and bits per pixel
  virtual void get_info(CamInfo *info) = 0;
  
  virtual void params(double p[]) = 0;
  
  virtual bool get_IPL(IPL_CONFIG *ipl_config) = 0;
};


class SeqCamera : public Camera {
  // index of next image to display
  int seq_index;

  // storage for camera sequences
  Picture *test_sequence[MAXSEQLEN];
  
 public:
  int  forward;               // forward/backward direction
  
  virtual bool open(IPL_CONFIG *ipl_config);
  virtual void close(void);
  virtual void read(Picture *p_frame);
  virtual bool iscolor(void);
  virtual void get_info(CamInfo *info);
  virtual void params(double p[]);
  virtual bool get_IPL(IPL_CONFIG *ipl_config);
};


#endif // Camera_h

