#ifndef ImprovWrapper_h
#define ImprovWrapper_h

#include "improc.h"

#ifndef _BYTE
#define _BYTE
typedef unsigned char BYTE;
#endif

#define MAX_IPL_OPS 16                 // max. operations per processor
#define NUM_VALS 16                    // don't know what this is


// enumerated values for IMPROV operations
typedef enum
{ 
  E_Optic_Flow,
  E_Optic_Flow_Camus, 
  E_Just_Optic_Flow_Camus,  
  E_Just_Optic_Flow_Liu, 
  E_Optic_Flow_Liu,
  
  E_Contour,
  
  /* IP functions */
  E_NOP,
  E_Identity,
  E_CamImg,
  E_Negation,
  E_Dithering,
  E_Difference,
  
  E_Count,
  E_Threshold,
  /*  E_NOP1,*/
  
  E_ColGray,
  E_MatchCol,
  E_HSV,
  /*  E_NOP2,*/
  
  E_Min,
  E_Max,
  E_Mean,
  E_Median,
  E_Laplace,
  E_Sobel,
  E_Corner,
  /*  E_NOP3,*/
  
  E_Erosion,
  E_Dilation,
  E_Open,
  E_Close,
  E_Fill,
  E_Connected,
  E_Boundary,
  E_Skeleton,
  /*  E_NOP4,*/
  
  E_Noise,
  E_GrayStretch,
  E_GrayReduce,
  E_ShowXY,
  E_Overlay,
  E_TestPalette,
  E_Region,
  E_Circles,
  E_Moravec,
  E_Track,
  E_HistEq,   
  E_Gauss, 
  
  E_Match_Color_Range,

  E_CameraOn_Off,

  //////////////////////
  //The image sequences
  /////////////////////
  E_S1,
  E_S2,
  E_S3,
  E_S4,
  E_S5,
  E_S6,
  E_S7,
  E_S8,
  E_S9,
  E_S10,
  E_S11,
  E_S12,
  E_S13,
  E_S14,
  E_S15
  
} E_IPLOP;


// identifier for IMPROV operation
typedef struct _IPLOP {
    E_IPLOP operation;                 // opcode
    double param[3];                   // parameters
    char text[80];                     // text to display in browser
    int num_param;                     // number of useful parameters
} IPLOP;


// menu item
typedef struct _Improv_Menu_Item {
    char text[50];                  // menu item label
    E_IPLOP operation;              // opcode
    int num_param;                  // number of useful parameters
} Improv_Menu_Item;


#include "Camera.h"

#endif // ImprovWrapper_h








