#if defined(__cplusplus)
extern "C" { 
#endif

#include "../FW/labImage.h"
#include "motion_field.h"


#ifndef _BYTE
#define _BYTE
  typedef unsigned char BYTE;
#endif
  
#ifndef _MAX_S_LIU 
#define MAX_S_LIU 25
#endif

#define INVALID 9e99
#define EPSILON 0.00001

  int calculate_optic_flow_liu(Picture *p_src, 
			       int W_x, int  W_y, int W_t, 
			       int x0, int y0, int x1, int y1,
			       int stepx, int stepy, 
			       float lampda_min,
			       float residual_min, 
			       float cond,
			       vec_field *liu_field, 
			       Picture *p_out);
  
  
  void extract_optic_flow(int x0, int y0, int x1, int y1, int t,
			  unsigned int wxy, unsigned int wt,
			  int stepx, int stepy,
			  float sigmaxy, float sigmat, 
			  float par1, float par2, float par3, float par6, 
			  Picture *p_out,
			  vec_field *motion_field);
  
  void init_floatpics(int t);
  void init_gaus_hermite(unsigned int wxy, unsigned int wt);

  void  build_lut_gaus_herm(int a, int c, float sigmaxy, float sigmat);
  float hermite(int i, int x, float sigma);
  float gaus(int x, float sigma);

  float norm_hermite(int i, int j, int k,
		     int a, int c);
  void init_math();
  
  void build_eqation(int x, int y, int t, unsigned int wx, unsigned int wy,
		     int x0,int y0,int x1, int y1);

  void solve_equation();
  
  float I_ijk(int i,int j, int k, int x, int y, int t, 
	      unsigned int wx, unsigned int wy,
	      int x0,int y0,int x1, int y1);
  
  void  generate_f_t(int a,int c, int x0, int y0, int x1, int y1,int t);
  void generate_f_t_fast(int a,int c, int x0, int y0, int x1, int y1,int t);
  
  void  generate_fx_t(int a, int x0, int y0, int x1, int y1,int t);
  void  generate_fx_t_fast(int a, int x0, int y0, int x1, int y1,int t);
  
  void  generate_fy_t(int a, int x0, int y0, int x1, int y1,int t);
  void  generate_fy_t_fast(int a, int x0, int y0, int x1, int y1,int t);
  
  int validate_vector(float par1, float par2, float par3);
  
  void matrix_mult_3x3_3x1(float **Q, float *b,float *Q_b);
  void transpose_3x3(float **A);
  void matrix_mult_3x3(float **P1, float **A, float **Q);
  void matrix_mult_3x3_3x2(float **P1,float **A, float **K);
  void calc_P1(float a11, float a21, float a31, float **P1);
  void calc_P2(float a11, float a21, float **P2);
  void write_matrices(char *fname,int x1,int y1);

  void realloc_gaus_hermite(int wxy, int wt);
  
  void write_in_motion_field_liu(int x, int y, 
				 float u, float v, 
				 vec_field *motion_field);

  Picture *make_pic_and_save(float *fp,char *fname, 
			     int x0, int y0, int x1, int y1);
#if defined(__cplusplus)
       }
#endif
