#if defined(__cplusplus)
extern "C" { 
#endif

#ifndef _MATHMI
#define _MATHMI

#ifndef SQRT2  
#define SQRT2 1.4142135624
#endif
  
#ifndef MAX
#define MAX(a,b) ((a)>=(b)?(a):(b))
#endif

#ifndef MIN
#define MIN(a,b) ((a)>=(b)?(b):(a))
#endif

#ifndef FMIN
#define FMIN(a,b) ((a)>=(b)?(b):(a))
#endif

#ifndef FMAX
#define FMAX(a,b) ( (a)<=(b)?(b):(a) )
#endif

#ifndef FABS
#define FABS(a) ((a)>=0.0?(a):((-1.0)*(a)))
#endif
  
  int least_square(float **A, int Acol,int Arow,
		    float *b, int brow,
		    float *x, int xrow,
		    float *residual);
  
  float **matrix_mult(float **F, int fcol, int frow, 
		      float **T, int tcol, int trow);
  
  float **calc_P(float **A, int col, int row, int coff, int roff);
  float normxnorm(float *u,int n);
  
  float *matrix_vector_mult(float **Q,int Qcol,int Qrow,float *b,int brow);

  void transpose_NxN(float **Q,int Qcol,int Qrow);
  void show_matrix(float **,int,int);
  
  float *vectorf(int nl,int nh);
  float **matrixf(int nrl,int nrh,int ncl,int nch);
  void freevectorf(float *v,int nl,int nh);
  void freematrixf(float **m, int nrl,int nrh,int ncl,int nch);
  void nrerror(char error_text[]);
  void write_matrices(char *fname,int x1,int y1);

  void svdcmp(float **a, int m, int n, float *w, float **v);

#endif _MATHMI
  
#if defined(__cplusplus)
}
#endif




