

/* 
 * Definitions
 */

/*
 * Comment out these #def's as needed
 */

//#define DEBUG    /* turn arguement checking on and off */
//#define SCREEN   /* debug information printed screen, 
//		    otherwise file debug.out */

#define DISPLAY  /* turns on and off display */

#define COLOUR   /* track using colour information */

#define RELAX    /* use interative relaxation */

//#define HIST     /* use histogram equalization */

#define MOTION   /* detect motion */


/* must have everything below */

#ifndef TRUE
#define TRUE  0
#endif

#ifndef FALSE
#define FALSE 1
#endif

/* GAUSSIAN */
#define SIZE 7
#define G    floor(SIZE/2)
#define VAR  2

/* TRACKING */
#define XX       4
#define xx       13
#define YY       3
#define yy       12
#define SEARCH   17

/* WEIGHTS FOR CHARACTERISTICS */
#define XNY   0.1
#define GRADS 0.1
#define INTS  0.2

/* MORAVEC */
#define MAX_POINTS     2000
#define supp_window    5
#define SW             floor(supp_window/2)
#define var_thres      0
#define supp_thres     pow(supp_window,2)-1
#define mor_window     5  /* must be odd */
#define M              floor(mor_window/2)
#define R              1  /* image reduction factor */

/* HISTGRAM EQUALIZATION */
#define HL 256    /* the number of grey levels */

/* CORRESPONDANCE */
#define AA 1
#define BB 0.5
#define CC 1
#define MISMATCH_THRES sqrt(2)
#define ITERATIONS 2

#define PROB_PROP  0.9
#define CRITICAL   5  /* can't lose more than CRITICAL points */

/* MOTION DETECTION */
#define MOTION_DTHRES   8     /* threshold for motion */
#define MOTION_NO_FEATS 4     /* minimum number of points required for
				 motion */


/*
 * Typedefs
 */

typedef struct _window
{

  short x1, y1;  /* top left corner */
  short x2, y2;  /* bottom right corner */

} window;

typedef struct _active
{
  
  window main;
  window *windows;
  
} active;

typedef struct _feature
{
  
  short   x,y;             /* pixel position */
  char    r,g,b;           /* intensities */
  double  grad_x, grad_y;  /* gradients */
  double  var;             /* maximum variance */
  int     active;          /* true if feature is being tracked */
  int     moving;          /* true if feature is moving */
  
} feature;


/* 
 * Forward Prototypes
 */


void IPL_moravec(Picture *p_imageIn, Picture *p_imageOut);
void IPL_Track(Picture *p_imageIn, Picture *p_imageOut);
void IPL_HistEq(Picture *p_imageIn, Picture *p_imageOut);
void IPL_Gauss(Picture *p_imageIn, Picture *imageOut);
void IPL_lum(Picture *p_imageIn, BYTE *p_imageOut);

/*
 * Internal Routines
 */

/* gaussian.c */
void     Generate_Gauss();
void     Gaussian_Smooth(BYTE * imageIn, BYTE * imageOut, 
			 int x1, int y1, int x2, int y2);
double   smooth_pixel(BYTE * image, int m, int i, int j);
void     gclamp(int *x1, int *y1, int *x2, int *y2);
void     smooth_areas( BYTE *imageIn, BYTE* imageOut);
double   smooth_pixel_col(BYTE * image, int g, int i, int j, int c);


/* track.c */
double   grad_x(BYTE * imageIn, int x, int y);
double   grad_y(BYTE * imageIn, int x, int y);
void     generate_windows(active* grid);
void     find_active_area(active *grid);
void     correspond(BYTE* col_im, BYTE *image, feature *s, 
		    IPLPoint *point, int no_points);
double   norm_feature(feature *a, double *w);
double   norm_diff_feature(feature *a, feature *b, double *w);
void     correspond2(BYTE* col_im, BYTE* image, 
		     IPLPoint** point, int* no_points);
void     similarity(BYTE* col_im, BYTE* image, IPLPoint** point, 
		int *no_points);
void     calc_probs(int* no_points);
void     choose(IPLPoint **point, int *no_points);
void     relax(IPLPoint **point, int* no_points);
double   sim_disparity(int k, int dx, int dy, IPLPoint* disparity,
		    IPLPoint** point, int* no_points);
double   disparity_mismatch(IPLPoint* a, IPLPoint* b);
int      still_tracking();
void     activate_lost(IPLPoint **point, int* no_points);
void     detect_motion();
int      can_track();


/* histeq.c */
void     Hist_Eq(BYTE * ImageIn, BYTE * ImageOut);
void     save_hist(unsigned int *n, BYTE *imageOut, 
		   int x1, int y1, int x2, int y2);
void     Hist_Eq_Col(BYTE *imageIn, BYTE *imageOut);

		
/* moravec.c */
void     Detect_Prominent_Features(BYTE* col_im, BYTE *image, active *grid);
void     initial_moravec( BYTE * image, int x1, int y1, 
			int x2, int y2, feature *f);
void     interest(BYTE * image, int x1, int y1, 
		  int x2, int y2, double* var);
void     non_max_suppress(double* var, int x1, int y1, int x2, int y2,
			  IPLPoint *point, int *no_points);
int      find_features(BYTE* col_im, BYTE *imageOut);


/* misc.c */
void     draw_features(BYTE * image, int col);
void     draw_grid(window* grid, BYTE * image, int col);
void     square_im(BYTE * imageIn, BYTE * ImageOut);
void     WritePGM(char *filename, unsigned char *pixel, 
		  int width, int height, int grey_levels);
void     draw_points(BYTE *image, IPLPoint *points, int no_points);
void     draw_active(BYTE *image, active* grid);
void     draw_areas(BYTE *image, int col);
void     copy_features();
void     motion_test_im1(BYTE* imageIn);
void     motion_test_im2(BYTE* imageIn);


/* angles.c */
void direct(IPLPoint* target);
void draw_crosshair(BYTE* image, IPLPoint *target, int col);





