/*
 *   Image Processing Library
 *   Thomas Braunl, Univ. Stuttgart, 1996
 *   Additional Code by Gerrit Heitsch
 *   Adapted by Michael Rudolph
 *   derived after Braunl et al. : Parallel Image Processing, Springer, 2001
 *
 *
 */

#include "FW/labImage.h"

#if !defined(_IPL_IMPROC_H)
#define _IPL_IMPROC_H


#if defined (__cplusplus)
extern "C" {
#endif

#if !defined(_BYTE)
#define _BYTE
typedef unsigned char BYTE;
#endif

#if defined(IMPLEMENT_IPL)
#define MAX_IMAGE_SIZE (320*240)
#define MAX_CONTOUR  1000
#endif

#define ColWhite 255
#define ColBlack   0
#define GrayWhite 15
#define GrayBlack  0

/*
 *    image processing library configuration structure
 */

typedef struct
{
  int imageWidth;
  int imageHeight;
  pixel_format imageType;
  float image_ratio;
  
  int displayWidth;
  int displayHeight;
  int display_xOffset;
  int display_yOffset;

  int colorBlack;
  int colorWhite;
} IPL_CONFIG;


typedef struct
{
    short x;
    short y;
} IPLPoint;

typedef struct
{
    double x;
    double y;
} XYDistance;


void IPL_Optic_Flow(Picture *p_input,
		    float par1, float par2, float par3, 
		    float par4, float par5, float par6,
		    Picture *p_output);

void IPL_Optic_Flow_Camus(Picture *p_input,
			  float par1, float par2, float par3, 
			  float par4, float par5, float par6,
			  Picture *p_output);

void IPL_Just_Optic_Flow_Camus(Picture *p_input,
			       float par1, float par2, float par3, 
			       float par4, float par5, float par6,
			       Picture *p_output);

void IPL_Just_Optic_Flow_Liu(Picture *p_input,
			     float par1, float par2, float par3, 
			     float par4, float par5, float par6,
			     Picture *p_output);

void IPL_Optic_Flow_Liu(Picture *p_input,
			float par1, float par2, float par3, 
			float par4, float par5, float par6,
			Picture *p_output);

void IPL_init(IPL_CONFIG * config);

void IPL_col2gray(Picture *p_imageIn, Picture *p_imageOut);
void IPL_matchcol(Picture *p_imageIn, Picture *p_imageOut, 
		  BYTE r, BYTE g, BYTE b);

void IPL_laplace(Picture *p_imageIn, Picture *p_imageOut);
void IPL_sobel(Picture *p_imageIn, Picture *p_imageOut);
void IPL_mean(Picture *p_imageIn, Picture *p_imageOut);

void IPL_threshold(Picture *p_imageIn, Picture *p_imageOut, BYTE threshold);
void IPL_gray_stretch(Picture *p_imageIn, Picture *p_imageOut);
void IPL_gray_reduce(Picture *p_imageIn, Picture *p_imageOut, int numvals);
void IPL_gen_histogram (Picture *p_imageIn, int *histogram);
void IPL_equal_histogram (Picture *p_imageIn, Picture *p_imageOut, int *histogram);
void IPL_erosion (Picture *p_imageIn, Picture *p_imageOut, char * struc);
void IPL_dilation (Picture *p_imageIn, Picture *p_imageOut, char * struc);
void IPL_open (Picture *p_imageIn, Picture *p_imageOut, char * struc);
void IPL_close (Picture *p_imageIn, Picture *p_imageOut, char * struc);
void IPL_fill (Picture *p_imageIn, Picture *p_imageOut, 
	       int x, int y, char * struc);
void IPL_connected(Picture *p_imageIn, Picture *p_imageOut, 
		   int x, int y, char * struc);
void IPL_boundary(Picture *p_imageIn, Picture *p_imageOut, char * struc);
void IPL_skeleton(Picture *p_imageIn, Picture *p_imageOut, char * struc);
void IPL_identity(Picture *p_imageIn, Picture *p_imageOut);

int  IPL_contour(Picture *p_imageIn, 
		 Picture *p_imageOut, 
		 IPLPoint * result, 
		 BYTE threshold);

void IPL_median(Picture *p_imageIn, Picture *p_imageOut);
void IPL_min(Picture *p_imageIn, Picture *p_imageOut);
void IPL_max(Picture *p_imageIn, Picture *p_imageOut);
void IPL_negation(Picture *p_imageIn, Picture *p_imageOut);
int IPL_difference(Picture *p_image, Picture *p_imgOut);

void IPL_cont_ori(Picture *, Picture *,int, int, int);

void IPL_noise(Picture *p_imageIn, Picture *p_imageOut, double noise);

int  IPL_count(BYTE *imageIn, BYTE *imageOut, BYTE val);
int  IPL_count_nobound(BYTE *p_imageIn,BYTE *p_imageOut, BYTE val);
void IPL_corner(Picture *p_imageIn, Picture *p_imageOut);

void IPL_and(Picture *p_imageIn1, Picture *p_imageIn2, Picture *p_imageOut);
void IPL_or(Picture *p_imageIn1, Picture *p_imageIn2, Picture *p_imageOut);
int  IPL_equal(Picture *p_imageIn1, Picture *p_imageIn2);
int  IPL_equal_nobound(Picture *p_image1, Picture *p_image2);
void IPL_showxy(Picture *p_imageIn, Picture *p_imageOut, int x, int y);
void IPL_Cshowxy(Picture *p_imageIn, Picture *p_imageOut, int x, int y);

void IPL_dither(Picture *p_imageIn, Picture *p_imageOut);
void IPL_overlay(Picture *p_imageIn1, Picture *p_imageIn2, 
		 Picture *p_imageOut, BYTE gray_val);
void IPL_Coverlay(Picture *p_imageIn1, Picture *p_imageIn2, 
		  Picture *p_imageOut, BYTE r, BYTE g, BYTE b);


void IPL_region_growing(Picture *p_imageIn, Picture *p_imageOut, int thresh);
int  IPL_FindCircles(Picture *p_imageIn, Picture *p_imageOut, XYDistance * result);
void IPL_TestPalette(Picture *p_imageOut);

void IPL_HSVValue(Picture *p_imageIn, Picture *p_imageOut);

void rgbToHsv(double r, double g, double b, double *h, double *s, double *v);

void IPL_match_color_range(Picture *p_imageIn, Picture *p_imageOut,
			   float rf, float gf, float bf);

#include "feat_track/track.h"

#if defined (__cplusplus)
}
#endif



#endif
