#ifndef PIXWIDGET_H
#define PIXWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>

#include "FW/labImage.h"

class PixWidget : public QWidget
{
	public:
		PixWidget( QWidget *parent=0, const char *name=0 );
		PixWidget( QWidget *parent=0, int w=100, int h=30 );
		~PixWidget();
		void setPicture(Picture *p_in);
		void setScale(bool sc);
		void redraw();
		void clear();
	
	protected:
		void paintEvent(QPaintEvent* event);
		int pixwidth;
		int pixheight;
		int offset_x;
		int offset_y;

	private:
		QPixmap pixmap;
		bool scale;
		bool autoscale;
};

#endif

