/***************************************************************************
                            QuickCam.h  -  description
                             -------------------
    begin                : Tue May 14 23:20:33 WST 2002
    copyright            : (C) 2002 by Leon Koch
    email                : koch-la@ee.uwa.edu.au

	Code adapted from Improv 3

 ***************************************************************************/

#ifndef QCAMCamera_h
#define QCAMCamera_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Camera.h"
#include "qcam.h"
#include "FW/labImage.h"

#define QUICKCAM_WIDTH   160
#define QUICKCAM_HEIGHT  120

class QuickCam : public Camera {
  
	public:
		virtual bool  open(const char* device);
		virtual void  close(void);
		virtual void  read(Picture *p_frame);
		virtual bool  iscolor(void);
		virtual void  get_info(CamInfo *info);
		virtual void setBrightness(int value);
		virtual void setContrast(int value);
		virtual void setSaturation(int value);
		virtual void setAutoBrightness(bool on);
		virtual int getBrightness(void);
		virtual int getContrast(void);
		virtual int getSaturation(void);
		virtual bool getAutoBrightness(void);
	private:
		bool autobrightness;
};

extern QuickCam quickcam;

#endif
