/* Sequence header */

#ifndef SEQUENCE_H
#define SEQUENCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>

#include "FW/labImage.h"
#include "V4LCamera.h"
//#include "V4L2Camera.h"
#include "QuickCam.h"
#include "qcam.h"

#define MAXSEQNAMELEN 256
#define MAXSOURCE     4096

//#define V4L_PATH "/dev/video0"

typedef enum {
	OTHER,
	PIXMAP,
	V4L,
	V4L2,
	QCAM
} imageSeqType;

typedef enum {
	LOOP,
	BOUNCE,
	NOLOOP
} imageSeqLoopType;

class imageSeq {

	public:
		typedef enum {
			FORWARD,
			BACKWARD
		} directionType;

		imageSeq(imageSeqType type, const char *path);
		~imageSeq();

		static int file_select(const struct dirent *entry);
		int getNumFrames(void);

		Picture* tick(int frames=1);
		Picture* getCurrent(void);
		Picture* getNext(void);
		int getWidth(void);
		int getHeight(void);
		imageSeqType getSeqType(void);
		bool getCameraReady(void);
		Camera *getCamera(void);
		char *getInfo(void);

	private:
		char*    seqPath;
		dirent** seqFiles;
		char     seqInfo[MAXSOURCE];
		char**   namelist;

		imageSeqLoopType loopType;
		imageSeqType seqType;
		directionType direction;
		Picture** pics;
		Picture* current;
		int currentIndex;
		
		int numFrames;
		int width;
		int height;

		void GetSFiles(const char *dirpath, char *sinfo);

		Camera *camera;
		bool cameraReady;
};

#endif

