/* AnimThread.cpp
 * Last modified:
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */

#include "Improv.h"

void AnimThread::run()
{
	Improv* improv = Improv::Instance(0, NULL);
	long time, ticktime;
	struct timeval tv;
	struct timezone tz;
	char *fpsMsg=NULL;
	float fps[NUMPOINTS];
	float total=0.0;
	int i=0,j;

	for(j=0;j<NUMPOINTS;j++) {
		fps[j] = 0.0;
	}

	gettimeofday(&tv, &tz);
	time = tv.tv_usec + (tv.tv_sec*1000000);

	while(improv->isPlaying() == true) {
		// We can't call Improv's tick() method directly, as this causes XLib errors.
		improv->tick();
		/* Instead, we should post events, for a QObject in
		 * the main thread to catch, and then pass to Improv. */
		//QCustomEvent *e = new QCustomEvent(EVENTID);
		//QThread::postEvent(improv->qobject,e);

		gettimeofday(&tv, &tz);
		ticktime = (tv.tv_usec + (tv.tv_sec*1000000)) - time;

		if((ticktime < inv_fps)&&(ticktime > 0)&&(i!=NUMPOINTS-1)&&(this->unlimited==false)) {
			this->usleep(inv_fps - ticktime);
			gettimeofday(&tv, &tz);
			ticktime = (tv.tv_usec + (tv.tv_sec*1000000)) - time;
		}
		time = tv.tv_usec + (tv.tv_sec*1000000);

		fps[i++] = (float)1000000/(float)ticktime;
		if(i==NUMPOINTS) {
			i=0;

			// Average the fps over NUMPOINTS
			for(j=0,total=0.0;j<(NUMPOINTS-1);j++) {
				total += fps[j];
			}
			total = total/(float)(NUMPOINTS);

			if(total>=1000) {
				total = 999.9;
			}
			fpsMsg = (char *)malloc(sizeof(char)*10);
			if(fpsMsg==NULL) {
				fprintf(stderr,"Error: No memory available for frames per second message\n");
				this->exit();
			}
			sprintf(fpsMsg,"%.1f FPS", total);
			if(improv->isPlaying() == true) {
				improv->setStatusFPSMessage(fpsMsg);
			}
			gettimeofday(&tv, &tz);
			ticktime += (tv.tv_usec + (tv.tv_sec*1000000)) - time;
			if((ticktime < inv_fps)&&(ticktime > 0)&&(this->unlimited==false)) {
				this->usleep(inv_fps - ticktime);
			}
			gettimeofday(&tv, &tz);
			time = tv.tv_usec + (tv.tv_sec*1000000);
			//ticktime = (tv.tv_usec + (tv.tv_sec*1000000)) - time;
			//fps[NUMPOINTS-1] = (float)1000000/(float)ticktime;
		}
	}
	if(fpsMsg!=NULL) free(fpsMsg);
	this->exit();
}

void AnimThread::setFPS(int fps) {
	assert(fps > 0);
	this->inv_fps = (int)(1000000/(float)fps);
}

void AnimThread::setUnlimitedFPS(bool toggle) {
	this->unlimited = toggle;
}
