/*
 *   Adapted for ImprovQT Leon Koch (2002)
 *
 */

#include <stdlib.h>
#include <string.h>

#include "../FW/labImage.h"
#include "../improv_plugin.h"
#include "Contour_plugin.h"

#include "contour.h"

#define NUMBER_OF_OPERATIONS 1

IP_Descriptor ipl_plugin =
{
	5,
	"",
	"",
	"",
	"\nAdapted for ImprovQT by Leon Koch\n",
	NUMBER_OF_OPERATIONS,
	NULL              /*  IP_ops, filled out by the _init function  */
};

IP_Handle IP_Init()
{
	IP_Op *op;
	int i = 0;

	/*  Fill out the IP ops descriptions  */
	ipl_plugin.Ops = calloc(NUMBER_OF_OPERATIONS, sizeof(IP_Op));

	/*  Contour  */
	op = (IP_Op*) &(ipl_plugin.Ops[i++]);
	op->Category   = strdup("Advanced");
	op->Operation  = strdup("Contour\t(t)");
	op->Index      = i;
	op->InputCount = 1;
	op->ParamCount = 3;
	op->ParamNames = calloc(3, sizeof(char *));
	op->ParamNames[0] = strdup("Param 1");
	op->ParamNames[1] = strdup("Param 2");
	op->ParamNames[2] = strdup("Param 3");
	op->resultType = NORESULT;
	op->process    = Contour_cont_ori;

	if( i != NUMBER_OF_OPERATIONS ) {
		printf("Contour_plugin.c ERROR: Mismatched number of operations:\n" \
				" (i, NUMBER_OF_OPERATIONS) = (%d, %d)\n", i, NUMBER_OF_OPERATIONS);
		exit(1);
	}

	return NULL;
}


const IP_Descriptor* IP_Descriptor_get(unsigned long Index)
{
	return &ipl_plugin;
}


pluginReturnType Contour_cont_ori(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result)
{
	float p;
	Picture *p_imageIn = *p_imageInputs;
	if(params[0]>0.8) p=0.8;
	else p=params[0];
	if(p_imageIn->format==pix_grey) {
		setImageType(p_imageOut,pix_rgb24);
		resizeImage(p_imageOut,p_imageIn->width,p_imageIn->height);
		contour(p_imageIn,p_imageOut,(p * 10),(params[1] * 10),(params[2] * 10));
		p_imageOut = RGB2BGR32(p_imageOut);
		return NOERROR;
	}
	else {
		//printf("Must be gray image!\n");
		return WRONGFORMAT;
	}
}

