/* ImprovQTCamOpt.h
 * Last modified: 
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class ImprovQTCamOpt
 * Camera options dialog box.
 * This dialog allows modification of the camera parameters, Brightness, Contrast and Saturation.
 * @see Camera
 */

#ifndef IMPROVQTCAMOPT_H
#define IMPROVQTCAMOPT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qvariant.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qslider.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qstring.h>

#include "improvConfig.h"

class ImprovQTCamOpt : public QDialog
{
	Q_OBJECT
	public:
		/** Constructor. */
		ImprovQTCamOpt(QWidget* parent = 0, const char* name = 0, imageSeqType type=OTHER, Camera *_camera=NULL, bool modal = FALSE, WFlags fl = 0 );
		/** Destructor. Deletes the instance of the class. */
		~ImprovQTCamOpt();
		
		/** Get the type of camera that the widget has been setup to use. */
		imageSeqType getCameraType(void);
		/** MOdify the type of camera that the widget should read and alter parameters for. */
		void setCameraType(imageSeqType type, Camera *_camera);
		
		/** Get the current brightness value of the slider. */
		int getBrightness(void);
		/** Get the current contrast value of the slider. */
		int getContrast(void);
		/** Get the current saturation value of the slider. */
		int getSaturation(void);
		
	public slots:
		/** Slot for the brightness slider. @param value Value of the slider. */
		void slotBrightnessSlider(int value);
		/** Slot for the contrast slider. @param value Value of the slider. */
		void slotContrastSlider(int value);
		/** Slot for the satturation slider. @param value Value of the slider. */
		void slotSaturationSlider(int value);
		
	protected:
		/** Close event handler. */
		void closeEvent(QCloseEvent * e);

	private:
		/** */
		Camera *camera;
		/** */
		imageSeqType cameraType;
		/** */
		QLabel* saturationValueLabel;
		/** */
		QLabel* saturationTextLabel;
		/** */
		QLabel* brightnessTextLabel;
		/** */
		QLabel* brightnessValueLabel;
		/** */
		QLabel* contrastTextLabel;
		/** */
		QLabel* contrastValueLabel;
		/** */
		QSlider* brightnessSlider;
		/** */
		QSlider* contrastSlider;
		/** */
		QSlider* saturationSlider;

};

#endif
