/*
 *   Optic Flow Routines
 *
 *   Original code by Uli Mezger
 *
 *   Adapted for ImprovQT by Daniel Venkitachalam (2002)
 *
 */

#include <stdlib.h>
#include <string.h>

//#include "../FW/labImage.h"
#include "../improv_plugin.h"
#include "optic_flow_plugin.h"

//Optical Flow
#include "optical_flow_camus.h"
#include "optical_flow_liu.h"

#define NUMBER_OF_OPERATIONS 2

//Optical Flow and motion Routines
#define SUBSAMPLE_JUST 0
#define FACTOR 2    //by which factor?

IP_Descriptor ipl_plugin =
{
	3,
	"Optical Flow plugins",
	"Uli Mezger",
	"2002",
	"Optical flow routines\nAdapted for ImprovQT by Daniel Venkitachalam\n",
	NUMBER_OF_OPERATIONS,
	NULL              /*  IP_ops, filled out by the _init function  */
};

IP_Handle IP_Init()
{
	IP_Op *op;
	int i = 0;
	IP_Handle* hglobals;
	OpticGlobals* globals;

	/*  Fill out the IP ops descriptions  */
	ipl_plugin.Ops = (IP_Op*) calloc(NUMBER_OF_OPERATIONS, sizeof(IP_Op));

	/*  Camus  */
	op = (IP_Op*) &(ipl_plugin.Ops[i++]);
	op->Category   = (char*) strdup("Optical Flow");
	op->Operation  = (char*) strdup("Correlation(h,t,r)");
	op->Index      = i;
	op->InputCount = 1;
	op->ParamCount = 6;
	op->ParamNames = (char**) calloc(6, sizeof(char *));
	op->ParamNames[0] = (char *) strdup("param 1");
	op->ParamNames[1] = (char *) strdup("param 2");
	op->ParamNames[2] = (char *) strdup("param 3");
	op->ParamNames[3] = (char *) strdup("param 4");
	op->ParamNames[4] = (char *) strdup("param 5");
	op->ParamNames[5] = (char *) strdup("param 6");
	op->resultType = NORESULT;
	op->process    = OF_Just_Optic_Flow_Camus;

	/*  Liu  */
	op = (IP_Op*) &(ipl_plugin.Ops[i++]);
	op->Category   = (char*) strdup("Optical Flow");
	op->Operation  = (char*) strdup("Differential(h,t,r,)");
	op->Index      = i;
	op->InputCount = 1;
	op->ParamCount = 6;
	op->ParamNames = (char**) calloc(6, sizeof(char *));
	op->ParamNames[0] = (char *) strdup("Diff param 1");
	op->ParamNames[1] = (char *) strdup("Diff param 2");
	op->ParamNames[2] = (char *) strdup("Diff param 3");
	op->ParamNames[3] = (char *) strdup("Diff param 4");
	op->ParamNames[4] = (char *) strdup("Diff param 5");
	op->ParamNames[5] = (char *) strdup("Diff param 6");
	op->resultType = NORESULT;
	op->process    = OF_Just_Optic_Flow_Liu;

	if( i != NUMBER_OF_OPERATIONS ) {
		printf("optic_flow_plugin.c ERROR: Mismatched number of operations:\n" \
				" (i, NUMBER_OF_OPERATIONS) = (%d, %d)\n", i, NUMBER_OF_OPERATIONS);
		exit(1);
	}

	//  Initialise globals
	
	globals = (OpticGlobals*) malloc(sizeof(OpticGlobals));
	globals->count_pic = 0;
	globals->count_pic_liu = 0;
	hglobals = (IP_Handle*) globals;

	return hglobals;
}


const IP_Descriptor* 
IP_Descriptor_get(unsigned long Index)
{
	return &ipl_plugin;
}

pluginReturnType OF_Just_Optic_Flow_Camus(IP_Handle instance, Picture **p_imageInputs,
		Picture *p_output, float *params, void *result)
{ 
	OpticGlobals* globals = (OpticGlobals*) instance;
	Picture *p_input = *p_imageInputs;

#if SUBSAMPLE_JUST
	Picture *p_bet;
	p_bet=subsample_pic(p_input, p_output, FACTOR, 1);
	OF_by_camus(p_bet, params[0], params[1], params[2]+0.15,
			params[3], params[4], params[5], p_output, &(globals->count_pic));
	return NOERROR;
#else 
	if(p_input->format==pix_grey) {
		OF_by_camus(p_input, params[0], params[1], params[2]+0.15,
				params[3], params[4], params[5], p_output, &(globals->count_pic));
		return NOERROR;
	}
	else
		return WRONGFORMAT; //printf("Must be greyscale image!\n");
#endif
}

pluginReturnType OF_Just_Optic_Flow_Liu(IP_Handle instance, Picture **p_imageInputs,
		Picture *p_output, float *params, void *result)
{ 
	OpticGlobals* globals = (OpticGlobals*) instance;
	Picture *p_input = *p_imageInputs;
#if SUBSAMPLE_JUST 
	Picture *p_bet;
	p_bet=subsample_pic(p_input, p_output, FACTOR, 2);
	OF_by_liu(p_bet, params[0], params[1], params[2]+0.15,
			params[3], params[4], params[5], p_output, &(globals->count_pic_liu));
	return NOERROR;
#else
	if(p_input->format==pix_grey) {
		OF_by_liu(p_input, params[0], params[1], params[2]+0.15,
				params[3], params[4], params[5], p_output, &(globals->count_pic_liu));
		return NOERROR;
	}
	else
		return WRONGFORMAT; //printf("Must be greyscale image! \n");
#endif
}

