/* PluginMenu.cpp
 * Last modified:
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */

#include "Improv.h"

PluginMenu::PluginMenu(void)
{ 
	pluginCount = 0;
	mainMenu = new QPopupMenu();
}

PluginMenu::~PluginMenu(void)
{ 
	delete mainMenu;
}

int PluginMenu::addPlugin(Plugin *p)
{
	PluginOp *po;
	int i, j;
	char* c_category=NULL;
	QString category;
	char* name=NULL;
	char** param_names;
	unsigned int num_params, num_inputs;
	pluginResultType resultType;
	size_t resultSize;

	// Go through each operation and add them to the appropriate
	// QPopupMenu category

	for(i=0; i < (int) p->getNumOps(); i++) {
		// Create a new plugin entry and add to the list
		po = (PluginOp *) calloc(sizeof(PluginOp), 1);
		p->getOpInfo(i, &c_category, &name, &num_inputs, &num_params, &param_names, &resultType, &resultSize);

		//if(resultType == TEXT) printf("%s: TEXT\n",name);
		//if(resultType == NORESULT) printf("%s: NORESULT\n",name);

		po->name = new QString(name);
		po->plugin = p;
		po->opId = i;
		po->inputCount = num_inputs;
		po->numParams = num_params;
		po->menuId = pluginCount++;
		po->resultType = resultType;
		po->resultSize = resultSize;

		if(num_params > 0) {
			po->paramNames = new QStringList();

			for(unsigned int ii=0; ii<num_params; ii++) {
				assert(param_names);
				//printf("op name: %s\n", name);
				//printf("Num params: %d\n", num_params);
				//printf("Adding %s\n", param_names[ii]);
				(po->paramNames)->append(param_names[ii]);
				//printf("Added param name %s\n", param_names[ii]);
			}
		}
		else {
			po->paramNames = 0;
		}

		// Check the category and add to the list of categories if necessary
		category = QString(c_category);
		QStringList::iterator it = categoryList.find(category);

		if(it == categoryList.end()) {
			QPopupMenu* newCatMenu;
			categoryList.push_back(category);
			// Create a new popup menu named after category
			newCatMenu = new QPopupMenu(0, category);
			// Insert the operation into the new menu
			newCatMenu->insertItem(name, this, SLOT(activated(int)), 0, po->menuId);
			// Find the place to insert the new category menu
			for(j=0;j<(int)categoryMenuList.size();j++) {
				if(QString::compare(category,(categoryMenuList[j])->name())<0) break;
			}
			// Insert the menu into the list of category menus
			categoryMenuList.insert(categoryMenuList.at(j),newCatMenu);
			// Insert the menu into the main popup menu
			mainMenu->insertItem(category, newCatMenu, 0, j);
		}
		else {
			// Find the correct category menu
			for(QValueList<QPopupMenu*>::iterator it = categoryMenuList.begin();
					it != categoryMenuList.end(); ++it) {
				if( category == (*it)->name() ) {
					// Find the place to insert the new plugin
					for(j=0;j<(int)(*it)->count();j++) {
						if(QString::compare(QString(name),(*getPluginOp((*it)->idAt(j))->name))<0) break;
					}
					// Insert the new plugin into the category menu
					(*it)->insertItem(name, this, SLOT(activated(int)), 0, po->menuId, j);
					break;
				}
			}
		}
		po->category = &category;

		// Add plugin to the list
		pluginList.push_back(po);
	}

	return 0;
}

int PluginMenu::getPluginCount(void) {
	return pluginCount;
}

QPopupMenu* PluginMenu::getMainMenu(void)
{
	assert(mainMenu);
	return mainMenu;
}

void PluginMenu::printInfo(void)
{
	std::cout << "Categories:" << std::endl;
	for (QStringList::iterator it = categoryList.begin(); it != categoryList.end(); ++it) {
		std::cout << "  " << *it << std::endl;
	}
}

void PluginMenu::activated(int id)
{
	Improv* improv = Improv::Instance(0, NULL);

	improv->setMenuId(id);
}

PluginMenu::PluginOp* PluginMenu::getPluginOp(int index)
{
	if(index >= pluginCount || index < 0){
		printf("index: %d\npluginCount: %d\n", index, pluginCount);
	}
	assert(index < pluginCount && index >= 0);

	return pluginList[index];
}

int PluginMenu::getUniqueId(int index) {
	assert(index < pluginCount && index >= 0);
	return pluginList[index]->plugin->getUniqueId();
}


