/* QuickCam.h
 * Last modified: 
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 * Notes: Code adapted from Improv 3 (Code was broken in Improv 4.x)
 */
/** @class QuickCam
 * Implementation of the Camera class for QuickCam.
 * @see Camera
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_QUICKCAM

#ifndef QCAMCamera_h
#define QCAMCamera_h

#include <stdio.h>
#include <stdlib.h>
#include <sys/io.h>
#include <malloc.h>
#include <assert.h>

#include "Camera.h"
#include "qcam.h"
#include "FW/labImage.h"

#define QUICKCAM_WIDTH   160
#define QUICKCAM_HEIGHT  120

class QuickCam : public Camera {
	public:
		virtual bool open(void);
		virtual void close(void);
		virtual void read(Picture *p_frame);
		virtual bool iscolor(void);
		virtual void get_info(CamInfo *info);
		virtual void setBrightness(int value);
		virtual void setContrast(int value);
		virtual void setSaturation(int value);
		virtual void setAutoBrightness(bool on);
		virtual int getBrightness(void);
		virtual int getContrast(void);
		virtual int getSaturation(void);
		virtual bool getAutoBrightness(void);
	private:
		bool autobrightness;
};

extern QuickCam quickcam;

#endif /* QCAMCamera_h */

#endif /* HAVE_QUICKCAM */
