/* StatusWidget.h
 * Last modified: 
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class StatusWidget
 * A more complex application status bar.
 * This is not finished, or included in Improv 5
 * therefore no one should be looking at it.
 * That means YOU!
 */

#ifndef STATUSWIDGET_H
#define STATUSWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qwidget.h>
#include <qstatusbar.h>
#include <qlayout.h>

class StatusWidget : public QWidget
{
	public:
		/** Constructor. */
		StatusWidget(QWidget *parent=0);
		/** Destructor. Deletes the instance of the class. */
		~StatusWidget();
		/** */
		void setMessage(const char* msg);
		/** */
		void setMessage(const char* msg, int ms);
		/** */
		const char *getMessage(void);
		/** */
		void setFPSMessage(const char* msg);
		/** */
		const char *getFPSMessage(void);
		/** */
		void setResultMessage(const char* msg);
		/** */
		const char *getResultMessage(void);

	private:
		/** */
		const char *msg;
		/** */
		const char *fpsMsg;
		/** */
		const char *resultMsg;
		/** */
		QStatusBar *msgBar;
		/** */
		QStatusBar *fpsBar;
		/** */
		QStatusBar *resultBar;
		/** */
		QGridLayout *effectGridLayout;

};

#endif
