#ifndef LABIMAGE_H
#define LABIMAGE_H

#if defined(__cplusplus)
extern "C" { 
#endif

#include <stdio.h>
	/**********************************************************************/

	typedef enum {
		pix_unknown = 0,

		pix_bitmap,/* 1 bit per pixel, order 76543210 | 76543210 | ... */

		pix_grey4, /* 4 lowest bit in 8 bit byte */
		pix_grey,  /* 8 bit luminosity */

		pix_index, /* 8 bit indexed colors.  Use obdata to store the color table */

		pix_rggb,  /* 32 bit Eyecam native format */

		pix_rgb24, /*  RGB 24 bit (8:8:8)    */
		pix_rgb32, /* RGBa 32 bit (8:8:8:8) */
		pix_bgr24, /*  BGR 24 bit (8:8:8)    */
		pix_bgr32, /* BGRa 32 bit (8:8:8:8) */

		pix_hsv32, /* HSV 32 bit (8:8:8:8) Last byte is not used */

		/* XXX These must be verified and consistently defined against V4L, V4L2 */
		pix_yuyv,  /* YUV 16 bit (4:2:2 packed) */
		pix_yuv12, /* YUV 12 bit (4:2:0 planar) */
		pix_yuv9   /* YUV  9 bit (4:1:0 planar) */
	} pixel_format;

	typedef struct {
		int width, height;          /* size of image */
		int xoffset;                /* number of pixels offset in X direction */
		pixel_format format;        /* XYBitmap, XYPixmap, ZPixmap */
		int datasize;               /* Size of the mem block pointed to by data */
		unsigned char *data;        /* pointer to image data */
		int bytes_per_line;         /* accelarator to next line */
		int bytes_per_pixel;        /* bytes per pixel */
		int obformat;               /* format of the obdata */
		void *obdata;               /* hook for the object routines to hang on */
		int flags;                  /* PIC_READONLY */
	} Picture;


	/* Create Image Structs */
	Picture   *allocImage();
	Picture   *initImage(Picture *image);
	Picture   *newImage();
	void      freeImage(Picture *image);
	void      clearImage(Picture *image);
	void      setImageType(Picture *image, pixel_format type);
	int       resizeImage(Picture *image, unsigned int width, unsigned int height);

	/* Load and save Images */
	int       loadImage(char *fileN, Picture *image);
	int       loadImage_Info(char *fileN, Picture *image);
	void      saveImage2(char *LbaseN, Picture *image, char *p_comment);
	void      saveImage(char *LbaseN, Picture *image);
	void      saveImage2_Ascii(char *LbaseN, Picture *image, char *p_comment);
	void      saveImage_Ascii(char *LbaseN, Picture *image);

	/* Duplicate Images or Part of Images */
	Picture   *copyImage(Picture *image);
	Picture   *copyImage_cover(Picture *image); /* copy just the attributes */
	Picture   *cropImage(Picture *p_image, int x, int y, 
			unsigned int width, unsigned int height);

	/* Conversion */
	Picture   *MONO2RGB(Picture *p_image);
	Picture   *MONO2RGB32(Picture *p_image);
	Picture   *MONO2BGR32(Picture *p_image);

	Picture   *RGB2MONO(Picture *p_srgbimage, Picture *p_grayimage, int mode);
	Picture   *RGB2RGB32(Picture *p_image);
	Picture   *RGB2BGR32(Picture *p_image);

	Picture   *RGB322MONO(Picture *p_image, Picture *p_grayimage, int mode);
	Picture   *RGB322RGB(Picture *p_image);
	Picture   *RGB322BGR32(Picture *p_image);

	Picture   *BGR322MONO(Picture *p_image, Picture *p_grayimage, int mode);
	Picture   *BGR322RGB(Picture *p_image);
	Picture   *BGR322RGB32(Picture *p_image);

	/* Image Manipulation */
	int       scaleImage(Picture *image, unsigned int width, unsigned int height);
	int       subscaleImagexycrop(Picture *p_image, int startx, int starty,
			int width, int height, int samplefactorx, int samplefactory);
	int       subscaleImage(Picture *p_image, int samplefactor);
	int       subsampleImage(Picture *p_image, int samplefactor);
	void      clearImage_white(Picture *image);

#if defined(__cplusplus)
}
#endif

#endif /* LABIMAGE_H */
