
#if defined(__cplusplus)
extern "C" { 
#endif

#ifndef LABIMGDRAW_H
#define LABIMGDRAW_H

#include "labImage.h"
#include "labFont.h"

/*Set Default-Drawcolors                                              */
int  setDrawColorImage(unsigned char *p_rgb);
void setDrawColorImageR(unsigned char r);
void setDrawColorImageG(unsigned char g);
void setDrawColorImageB(unsigned char b);
void setDrawGValImage(unsigned char grayval);
void setDrawGShort(short grayshort);

/*Change the whole Image                                              */
int reshapeImage_g(Picture *p_image, int xs, int ys, int w, int h, 
                                                 unsigned char bgnd);
int reshapeImage_rgb(Picture *p_image, int xs, int ys, int w, int h, 
                   unsigned char r, unsigned char g, unsigned char b);
int reshapeImage(Picture *p_image, int xs, int ys, int w, int h);


int putImageInImageOverlay(Picture *p_image, Picture *p_img2, int x,int y,
                        int overlay, int cutimg2, unsigned char bgnd);
int putImageInImage(Picture *p_image, Picture *p_img, int x, int y);

/*Produce new, changed Images                                         */
Picture *invertImage(Picture *p_image);
Picture *ReGrayImage(Picture *p_image, int gray);
Picture *ReColorImage(Picture *p_image , int red, int green, int blue);
Picture *Images_to_Colorchannels(
               Picture *p_img1, char color1, int x1, int y1,
               Picture *p_img2, char color2, int x2, int y2,
               Picture *p_img3, char color3, int x3, int y3,
                                             int cut_to_imgsize);

/*Draw Figures into an Image                                          */
  /*Points*/
  int PutPixelInImage(Picture *p_image, int x, int y);
  int PutPixelInImageF(Picture *p_image, float x, float y);
  int PutBigPixelInImage(Picture *p_image, int x, int y, int pointsize);
  
  /*Lines*/
  int drawHorizontalInImage(Picture *p_image, int y, int x1, int x2);
  int drawLineInImage(Picture *p_image, int x1, int y1, int x2, int y2, 
		    int linewidth);
  int drawLineInImageF(Picture *p_image, 
		     float x1, float y1, float x2, float y2, int linewidth);

  /*Polygons*/
int drawPolygon(Picture *p_image, int N, int *x, int *y, int closed, 
		int linewidth);
  int drawPolygonF(Picture *p_image, int N, float *x,float *y,int closed, 
		 int linewidth);
  int fillPolygon(Picture *p_image, int N, int *x, int *y);
  int fillPolygonF(Picture *p_image, int N, float *x, float *y);

  /*Rectangles*/
  int drawRectInImage(Picture *p_image, int x1, int y1, int w, int h, 
		    int linewidth);
int drawRectInImageF(Picture *p_image, 
		     float x, float y, float w, float h, 
		     int linewidth);
  int fillRectInImage(Picture *p_image, int x, int y, int w, int h);
  int fillRectInImageF(Picture *p_image, float x, float y, float w,float h);
  
  /*Circle and Ellipses*/
  int drawCircleInImage(Picture *p_image, int cx, int cy, int r, 
		      int linewidth);
  int fillCircleInImage(Picture *p_image, int cx, int cy, int r);
  

  int drawEllipseInImage(Picture *p_image, int cx, int cy, int R1, int R2, 
                                                       int linewidth);
  int fillEllipseInImage(Picture *p_image, int cx, int cy, int R1, int R2);
  
  /*Draw Strings into an Image*/
  int drawStringInImage(Picture *p_image, int x, int y, 
			const char *p_string, MyFont *p_font, 
			int red, int green, int blue, int spacing,
			int resizeimg, unsigned char bgnd);
  int drawStringInImageF(Picture *p_image, float x,float y, 
			 const char *p_string,  MyFont *p_font, 
			 int red, int green, int blue, int spacing, 
		       int resizeimg, unsigned char bgnd);
  
  int createSinusoid(Picture *p_image,int xoffset,int yoffset, int ,int);
  
#define GETPIXELVALUE(p_image,x,y) (*(((unsigned char *) p_image->data)+y*p_image->width+x))

#if defined(__cplusplus)
}
#endif

#endif


