/* ImprovQT.cpp
 * Last modified:
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Improv.h"
#include "ImprovQT.h"

#include "pixmaps/appicon.xpm"
#include "pixmaps/filesave.xpm"
//#include "pixmaps/fileopen.xpm"
#include "pixmaps/filenew.xpm"
#include "pixmaps/play.xpm"
#include "pixmaps/stop.xpm"
#include "pixmaps/forward.xpm"
#include "pixmaps/fastforward.xpm"
#include "pixmaps/backward.xpm"
#include "pixmaps/rewind.xpm"
#include "pixmaps/configure.xpm"
#include "pixmaps/unlimited.xpm"
#include "pixmaps/hal.xpm"

/*  Global pointer to singleton initialised in constructor  */

ImprovQTApp::ImprovQTApp() {
	setCaption(tr("ImprovQT " VERSION " - Image Processing for Robot Vision"));
	setIcon(appicon_xpm);

	///////////////////////////////////////////////////////////////////
	// call inits to invoke all other construction parts
	initActions();
	initMenuBar();
	initToolBar();
	initStatusBar();

	//initDoc();
	initView();
	initCamera();

	viewToolBar->setOn(true);
	viewStatusBar->setOn(true);

	slotViewToolBar(true);

//	resize(790,720);
//	this->setMaximumWidth(view->width());
//	this->setMaximumHeight(view->height());
//	printf("Max width: %d, max height %d\n", this->maximumWidth(), this->maximumHeight());

//	this->setFixedWidth(778);

//	int width, height;
//	Improv* improv = Improv::Instance(0, NULL);
//	switch(improv->config->getNumSeqWindows()) {
//		case 2:
//			width = 2;
//			break;
//		default:
//			width = 3;
//			break;
//	}
//	width = improv->config->getWindowWidth() * width;
//	height = (improv->config->getWindowHeight() + 70) * (int)ceil(improv->config->getNumSeqWindows()/3);
//	this->setMinimumWidth(width);
//	this->setMinimumHeight(height);
//	resize(width,height);
//	printf("set width to %d\n", width);
//	printf("set height to %d\n", height);
}

ImprovQTApp::~ImprovQTApp() {
	// no need to delete child widgets, Qt does it all for us
	delete view;
	//delete doc;
	//delete fileMenu;
	//delete viewMenu;
	//delete helpMenu;
	//delete fileToolbar;
	//delete animToolbar;
	//delete paramToolbar;
	//delete paramWidget;
}

/** initializes all QActions of the application */
void ImprovQTApp::initActions() {
	Improv* improv = Improv::Instance(0, NULL);

	QPixmap openIcon, saveIcon, newIcon;
	newIcon = QPixmap(filenew);
	//openIcon = QPixmap(fileopen);
	saveIcon = QPixmap(filesave);

	QPixmap playIcon, stopIcon, forwardIcon,
	fastForwardIcon, backwardIcon, rewindIcon,
	optionsIcon, fpsUnlimitedIcon;
	playIcon = QPixmap(play_xpm);
	stopIcon = QPixmap(stop_xpm);
	forwardIcon = QPixmap(forward_xpm);
	fastForwardIcon = QPixmap(fastforward_xpm);
	backwardIcon = QPixmap(backward_xpm);
	rewindIcon = QPixmap(rewind_xpm);
	optionsIcon = QPixmap(configure_xpm);
	fpsUnlimitedIcon = QPixmap(unlimited_xpm);

	/*  File menu entries  */

//	fileOpenImage = new QAction(tr("Add image sequence"), openIcon,
//			tr("&Add image sequence"), QAccel::stringToKey(tr("Ctrl+O")), this);
//	fileOpenImage->setStatusTip(tr("Add image sequence"));
//	fileOpenImage->setWhatsThis(tr("Add image sequence\n\nAdds a sequence to the list"));
//	connect(fileOpenImage, SIGNAL(activated()), this, SLOT(slotFileOpenImage()));

	fileSaveImage = new QAction(tr("Save Image sequence"), saveIcon, 
			tr("&Save image sequence"), QAccel::stringToKey(tr("Ctrl+S")), this);
	fileSaveImage->setStatusTip(tr("Saves the current image set"));
	fileSaveImage->setWhatsThis(tr("Save Image Set.\n\nSaves the current image set"));
	connect(fileSaveImage, SIGNAL(activated()), this, SLOT(slotFileSaveImage()));

	fileSaveConfig = new QAction(tr("Save configuration"), tr("Save &configuration"), QKeySequence(), this);
	fileSaveConfig->setStatusTip(tr("Saves the current application configuration"));
	fileSaveConfig->setWhatsThis(tr("Save configuration.\n\nSaves the current application configuration"));
	connect(fileSaveConfig, SIGNAL(activated()), this, SLOT(slotFileSaveConfig()));

	fileSaveConfigAs = new QAction(tr("Save configuration as..."), tr("Save &configuration as..."), QKeySequence(), this);
	fileSaveConfigAs->setStatusTip(tr("Saves the current application configuration"));
	fileSaveConfigAs->setWhatsThis(tr("Save configuration.\n\nSaves the current application configuration"));
	connect(fileSaveConfigAs, SIGNAL(activated()), this, SLOT(slotFileSaveConfigAs()));

	fileOptions = new QAction(tr("Edit Options"), optionsIcon,
			tr("&Edit options"), QAccel::stringToKey(tr("Ctrl+e")), this);
	fileOptions->setStatusTip(tr("Edits the program options"));
	fileOptions->setWhatsThis(tr("Edit options.\n\nEdits the program options"));
	connect(fileOptions, SIGNAL(activated()), this, SLOT(slotFileOptions()));

	fileQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
	fileQuit->setStatusTip(tr("Quits the application"));
	fileQuit->setWhatsThis(tr("Exit\n\nQuits the application"));
	connect(fileQuit, SIGNAL(activated()), this, SLOT(slotFileQuit()));

	/*  Anim toolbar options  */
	animPlay = new QAction(tr("Play"), playIcon, tr("&Play"),
			QAccel::stringToKey(tr("Ctrl+P")), this);
	animPlay->setStatusTip(tr("Play"));
	animPlay->setWhatsThis(tr("Play\n\nPlay the image sequence"));
	connect(animPlay, SIGNAL(activated()), this, SLOT(slotAnimPlay()));

	animStop = new QAction(tr("Stop"), stopIcon, tr("&Stop"), 
			QAccel::stringToKey(tr("Ctrl+B")), this);
	animStop->setStatusTip(tr("Stop"));
	animStop->setWhatsThis(tr("Stop\n\nStops the image sequence"));
	animStop->setEnabled(false);
	connect(animStop, SIGNAL(activated()), this, SLOT(slotAnimStop()));

	animForward = new QAction(tr("Forward"), forwardIcon, tr("&Forward"),
			QAccel::stringToKey(tr("Ctrl+=")), this);
	animForward->setStatusTip(tr("Forward"));
	animForward->setWhatsThis(tr("Forward\n\nSteps through one frame"));
	animForward->setEnabled(true);
	connect(animForward, SIGNAL(activated()), this, SLOT(slotAnimForward()));

	animFastForward = new QAction(tr("Fast Forward"), fastForwardIcon, tr("&Fast Forward"),
			QAccel::stringToKey(tr("Ctrl+'")), this);
	animFastForward->setStatusTip(tr("Fast Forward"));
	animFastForward->setWhatsThis(tr("Fast Forward\n\nSteps through 10 frames"));
	animFastForward->setEnabled(true);
	connect(animFastForward, SIGNAL(activated()), this, SLOT(slotAnimFastForward()));

	animBackward = new QAction(tr("Backward"), backwardIcon, tr("&Backward"),
			QAccel::stringToKey(tr("Ctrl+-")), this);
	animBackward->setStatusTip(tr("Backward"));
	animBackward->setWhatsThis(tr("Backward\n\nSteps back through one frame"));
	animBackward->setEnabled(true);
	connect(animBackward, SIGNAL(activated()), this, SLOT(slotAnimBackward()));

	animRewind = new QAction(tr("Rewind"), rewindIcon, tr("&Rewind"),
			QAccel::stringToKey(tr("Ctrl+;")), this);
	animRewind->setStatusTip(tr("Rewind"));
	animRewind->setWhatsThis(tr("Rewind\n\nSteps back through 10 frames"));
	animRewind->setEnabled(true);
	connect(animRewind, SIGNAL(activated()), this, SLOT(slotAnimRewind()));

	fpsUnlimited = new QAction(tr("Unlimited FPS"), fpsUnlimitedIcon, tr("&Unlimited FPS"),
			QAccel::stringToKey(tr("Ctrl+u")),this,0,true);
	fpsUnlimited->setStatusTip("Unlimited FPS");
	fpsUnlimited->setWhatsThis(tr("Unlimited FPS\n\nToggle unlimited frames per second"));
	fpsUnlimited->setEnabled(true);
	connect(fpsUnlimited, SIGNAL(toggled(bool)), this, SLOT(slotSetUnlimitedFPS(bool)));
	
	viewToolBar = new QAction(tr("Toolbar"), tr("Tool&bar"), 0, this, 0, true);
	viewToolBar->setStatusTip(tr("Enables/disables the toolbar"));
	viewToolBar->setWhatsThis(tr("Toolbar\n\nEnables/disables the toolbar"));
	//viewToolBar->toggle();
	connect(viewToolBar, SIGNAL(toggled(bool)), this, SLOT(slotViewToolBar(bool)));

	viewStatusBar = new QAction(tr("Statusbar"), tr("&Statusbar"), 0, this, 0, true);
	viewStatusBar->setStatusTip(tr("Enables/disables the statusbar"));
	viewStatusBar->setWhatsThis(tr("Statusbar\n\nEnables/disables the statusbar"));
	connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));

	viewCameraOptions = new QAction(tr("Camera Options"), tr("&Camera Options"), 0, this, 0, true);
	viewCameraOptions->setStatusTip(tr("Enables/disables the camera options window"));
	viewCameraOptions->setWhatsThis(tr("Camera Options\n\nEnables/disables the camera options window"));
	viewCameraOptions->setOn(false);
	connect(viewCameraOptions, SIGNAL(toggled(bool)), this, SLOT(slotViewCameraOptions(bool)));
	improv->setCamOptAction(viewCameraOptions);	

	helpApp = new QAction(tr("Help"), tr("&Help..."), 0, this);
	helpApp->setStatusTip(tr("Helpful information about the application"));
	helpApp->setWhatsThis(tr("Help\n\nHelpful information about the application"));
	connect(helpApp, SIGNAL(activated()), this, SLOT(slotHelp()));

	helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
	helpAboutApp->setStatusTip(tr("About the application"));
	helpAboutApp->setWhatsThis(tr("About\n\nAbout the application"));
	connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));
}

void ImprovQTApp::initMenuBar()
{
	///////////////////////////////////////////////////////////////////
	// menuBar entry fileMenu
	fileMenu=new QPopupMenu();
	fileMenu->insertSeparator();
	//fileOpenImage->addTo(fileMenu);
	fileSaveImage->addTo(fileMenu);
	fileMenu->insertSeparator();
	fileSaveConfig->addTo(fileMenu);
	fileSaveConfigAs->addTo(fileMenu);
	fileOptions->addTo(fileMenu);
	fileMenu->insertSeparator();
	fileQuit->addTo(fileMenu);

	// menuBar entry viewMenu
	viewMenu=new QPopupMenu();
	viewMenu->setCheckable(true);
	viewToolBar->addTo(viewMenu);
	viewStatusBar->addTo(viewMenu);
	viewCameraOptions->addTo(viewMenu);

	// menuBar entry helpMenu
	helpMenu=new QPopupMenu();
	helpApp->addTo(helpMenu);
	helpAboutApp->addTo(helpMenu);

	///////////////////////////////////////////////////////////////////
	// MENUBAR CONFIGURATION
	menuBar()->insertItem(tr("&File"), fileMenu);
	menuBar()->insertItem(tr("&View"), viewMenu);
	menuBar()->insertSeparator();
	menuBar()->insertItem(tr("&Help"), helpMenu);

}

void ImprovQTApp::initToolBar()
{
	Improv* improv = Improv::Instance(0, NULL);

	///////////////////////////////////////////////////////////////////
	// TOOLBAR
	fileToolbar = new QToolBar(this, "file operations");
	fileToolbar->setLabel("File");
	//fileOpenImage->addTo(fileToolbar);
	fileSaveImage->addTo(fileToolbar);
	fileToolbar->addSeparator();
	fileOptions->addTo(fileToolbar);
	fileToolbar->addSeparator();
	QWhatsThis::whatsThisButton(fileToolbar);

	///////////////////////////////////////////////////////////////////
	// ANIM TOOLBAR
	animToolbar = new QToolBar(this, "animation operations");
	animToolbar->setLabel("Playback");
	animRewind->addTo(animToolbar);
	animBackward->addTo(animToolbar);
	animStop->addTo(animToolbar);
	animPlay->addTo(animToolbar);
	animForward->addTo(animToolbar);
	animFastForward->addTo(animToolbar);
	animToolbar->addSeparator();
	targetLabel = new QLabel("Target FPS: ", animToolbar);
	fpsBox = new QSpinBox(animToolbar, "frames per second");
	fpsBox->setMaxValue(999);
	fpsBox->setMinValue(1);
	fpsBox->setValue(25);
	QWhatsThis::add(fpsBox,tr("Target frames per second\n\nDisplay rate of the image sequence"));
	connect(fpsBox, SIGNAL(valueChanged(int)), this, SLOT(slotSetFPS(int)));
	fpsUnlimited->addTo(animToolbar);
	
	///////////////////////////////////////////////////////////////////
	// PARAMETER TOOLBAR
	paramToolbar = new QToolBar(this, "plugin parameters");
	paramToolbar->setLabel("Parameters");
	int width;
	int windowWidth;
	windowWidth = improv->config->getWindowWidth();
	if(windowWidth<MINIMUM_BUTTON_BAR_WIDTH) {
		windowWidth = MINIMUM_BUTTON_BAR_WIDTH;
	}	
	width = (windowWidth*improv->config->getNumCols())-170;
	paramWidget = new ParamWidget(paramToolbar, "parameter widget", width);
	improv->setParamWidget(paramWidget);

}

void ImprovQTApp::initStatusBar()
{
	///////////////////////////////////////////////////////////////////
	//STATUSBAR
	Improv* improv = Improv::Instance(0, NULL);
	statusBar()->message(tr(IDLEMSG));
	statusBar()->setMinimumHeight(statusBar()->height());

	// new
//	QStatusBar *status = new QStatusBar();
//	StatusWidget *statusWidget = new StatusWidget(this);
//	statusWidget->setMaximumHeight(30);
//	statusWidget->setMinimumHeight(30);
//	statusWidget->setMaximumWidth(improv->config->getWindowWidth()*3);
//	statusWidget->setMinimumWidth(improv->config->getWindowWidth()*3);
//	status->addWidget(statusWidget,1,false);
//	improv->setStatusBar(status);
//	fprintf(stderr,"width: %d height: %d\n", statusWidget->width(), statusWidget->height());
	// new

	improv->setStatusBar(statusBar());
	improv->setStatusMessage(IDLEMSG);
}

/*void ImprovQTApp::initDoc()
{
	doc=new ImprovQTDoc();
} */

void ImprovQTApp::initView()
{
	////////////////////////////////////////////////////////////////////
	// set the main widget here
	//view=new ImprovQTView(this, doc);
	view=new ImprovQTView(this);
	setCentralWidget(view);
}

void ImprovQTApp::initCamera() {
	ImprovQTCamOpt *camOptions;
	Improv* improv = Improv::Instance(0, NULL);
	camOptions = new ImprovQTCamOpt(this,0,OTHER);
	improv->setCamOpt(camOptions);
	improv->setCamOptOpen(false);
}

bool ImprovQTApp::queryExit()
{
	bool exit=false;
	Improv* improv = Improv::Instance(0, NULL);
	/*int exit=QMessageBox::information(this, tr("Quit..."),
			tr("Do your really want to quit?"),
			QMessageBox::Ok, QMessageBox::Cancel);*/

	int save=QMessageBox::information(this, tr("Save configuration?"),
			tr("The configuration has been modified\n\nSave configuration?"),
			QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel);

	if(save==QMessageBox::Yes) {
		improv->config->save();
		exit = true;
	}
	if(save==QMessageBox::No) {
		exit = true;
	}
	if(save==QMessageBox::Cancel) {
		exit = false;
	}
	return exit;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


//void ImprovQTApp::slotFileOpenImage()
//{
//	statusBar()->message(tr("Opening file..."));
//
//	QString fileName = QFileDialog::getOpenFileName(0,0,this);
//	if (!fileName.isEmpty())
//	{
//		//doc->load(fileName);
//		setCaption(fileName);
//		QString message=tr("Loaded document: ")+fileName;
//		statusBar()->message(message, 2000);
//	}
//	else
//	{
//		statusBar()->message(tr("Opening aborted"), 2000);
//	}
//}


void ImprovQTApp::slotFileSaveImage()
{
	QString s;
	QValueList<SrcWidget*>::iterator srcIt;
	QValueList<SeqWidget*>::iterator seqIt;
	QValueList<SrcWidget*> srcWidgetList;
	QValueList<SeqWidget*> seqWidgetList;
  Improv* improv = Improv::Instance(0, NULL);
	improv->setStatusMessage("Saving image files...");
	srcWidgetList = improv->getSrcWidgetList();
	seqWidgetList = improv->getSeqWidgetList();
	for(srcIt=srcWidgetList.begin(); srcIt!=srcWidgetList.end(); srcIt++) {
		if((*srcIt)->getCurrent()!=NULL) {
			if((*srcIt)->getCurrent()->format==pix_grey)
				saveImage((char *)s.sprintf("source%d.pgm",(*srcIt)->getId()).latin1(),(*srcIt)->getCurrent());
			else
				saveImage((char *)s.sprintf("source%d.ppm",(*srcIt)->getId()).latin1(),(*srcIt)->getCurrent());
		}
	}
	for(seqIt=seqWidgetList.begin(); seqIt!=seqWidgetList.end(); seqIt++) {
		if((*seqIt)->getCurrent()!=NULL) {
			if((*seqIt)->getCurrent()->format==pix_grey)
				saveImage((char *)s.sprintf("sequence%d.pgm",(*seqIt)->getId()).latin1(),(*seqIt)->getCurrent());
			else
				saveImage((char *)s.sprintf("sequence%d.ppm",(*seqIt)->getId()).latin1(),(*seqIt)->getCurrent());
		}
	}
	improv->setStatusMessage("Image files saved",3000);
}

//void ImprovQTApp::slotFileSaveImageAs()
//{
//	statusBar()->message(tr("Saving file under new filename..."));
//	QString fn = QFileDialog::getSaveFileName(0, 0, this);
//	if (!fn.isEmpty())
//	{
//		//doc->saveAs(fn);
//		statusBar()->message(tr("File saved"), 2000);
//	}
//	else
//	{
//		statusBar()->message(tr("Saving aborted"), 2000);
//	}
//}

void ImprovQTApp::slotFileSaveConfig() {
	Improv* improv = Improv::Instance(0, NULL);
	improv->config->save();
	improv->setStatusMessage("Configuration saved",2000);
}

void ImprovQTApp::slotFileSaveConfigAs() {
	Improv* improv = Improv::Instance(0, NULL);
	statusBar()->message(tr("Saving configuration under new filename..."));
	QString fn = QFileDialog::getSaveFileName(0, 0, this);
	if (!fn.isEmpty())
	{
		improv->config->saveAs((char *)fn.latin1());
		improv->setStatusMessage("Configuration saved",2000);
	}
	else
	{
		improv->setStatusMessage("Saving aborted", 2000);
	}
}

void ImprovQTApp::slotFileClose()
{
	statusBar()->message(tr("Closing file..."));

	statusBar()->message(tr(IDLEMSG));
}

void ImprovQTApp::slotFileOptions() {
	ImprovQTOpt* opt;
	Improv* improv = Improv::Instance(0, NULL);
	slotAnimStop();
	//improv->setPlaying(false);
	improvConfig* config = improv->config;
	//opt = new ImprovQTOpt(this,"Options",this->view,config);
	opt = new ImprovQTOpt(this,"Options",config);
	improv->setStatusMessage("Options");
	opt->show();
}

void ImprovQTApp::slotFileQuit()
{
	bool wasPlaying = false;
	Improv* improv = Improv::Instance(0, NULL);
	if(improv->isPlaying()) {
		improv->setPlaying(false);
		//sleep(2);
		wasPlaying = true;
	}
	improv->setStatusMessage("Exiting application...");
			
	///////////////////////////////////////////////////////////////////
	// exits the Application
	//if(doc->isModified())
	if(improv->config->isModified())
	{
		if(queryExit())
		{
			Improv* improv = Improv::Instance(0, NULL);
			delete improv;
			delete this;
			qApp->quit();
		}
		else
		{
			if(wasPlaying) improv->setPlaying(true);
			else improv->setStatusMessage(IDLEMSG);
		}
	}
	else
	{
		Improv* improv = Improv::Instance(0, NULL);
		delete improv;
		delete this;
		qApp->quit();
	}
}

//void ImprovQTApp::slotEditCut()
//{
//	statusBar()->message(tr("Cutting selection..."));
//
//	statusBar()->message(tr(IDLEMSG));
//}

//void ImprovQTApp::slotEditCopy()
//{
//	statusBar()->message(tr("Copying selection to clipboard..."));
//
//	statusBar()->message(tr(IDLEMSG));
//}

//void ImprovQTApp::slotEditPaste()
//{
//	statusBar()->message(tr("Inserting clipboard contents..."));
//
//	statusBar()->message(tr(IDLEMSG));
//}

void ImprovQTApp::slotViewToolBar(bool toggle)
{
	statusBar()->message(tr("Toggle toolbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off

	if (toggle== false)
	{
		fileToolbar->hide();
	}
	else
	{
		fileToolbar->show();
	};

	statusBar()->message(tr(IDLEMSG));
}

void ImprovQTApp::slotViewStatusBar(bool toggle)
{
	statusBar()->message(tr("Toggle statusbar..."));
	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off

	if (toggle == false)
	{
		statusBar()->hide();
	}
	else
	{
		statusBar()->show();
	}

	statusBar()->message(tr(IDLEMSG));
}

void ImprovQTApp::slotViewCameraOptions(bool toggle) {
	Improv* improv = Improv::Instance(0, NULL);
	statusBar()->message(tr("Toggle Camera Options..."));
	if (toggle == false) {
		improv->getCamOpt()->hide();
		improv->setCamOptOpen(toggle);
	}
	else {
		improv->getCamOpt()->show();
		improv->setCamOptOpen(toggle);
	}
	statusBar()->message(tr(IDLEMSG));
}

void ImprovQTApp::slotHelp()
{
	ImprovQTHelp *help = new ImprovQTHelp(this);
	help->show();
}

void ImprovQTApp::slotHelpAbout()
{
	QPixmap about_icon(hal_xpm);
	QMessageBox about(tr("About..."),
			tr("ImprovQT " VERSION " - Image Processing for Robot Vision\n\n" \
				"QT v5.1 by Leon Koch <koch-la@ee.uwa.edu.au> & Supervised by Thomas Braunl\n" \
				"QT v5.0 by Leon Koch <koch-la@ee.uwa.edu.au>, \n" \
				"           Daniel Venkitachalam <venki-d@ee.uwa.edu.au> & Supervised by Thomas Braunl\n" \
				"v4.1 by Thomas Braunl <braunl@ee.uwa.edu.au>\n" \
				"v4.0 by Thomas Braunl, Uli Mezger <ul@ei.turn.de>, Paul McAlpine\n" \
				"v1.0 by Thomas Braunl and Michael Rudolph\n\n"\
				"Color by Thomas Braunl and Elliot Nicholls <nicho-ej@ee.uwa.edu.au>\n"\
				"Parts of the IPL by Gerrit Heisch <heitscgt@informatik.uni-stuttgart.de>\n\n"\
				"The University of Western Australia, E&E Eng., CIIPS 2002\n\n"\
				"Using XFQCam and QuickCam code by Paul Chinn <loomer@1000klub.com>\n"\
				" Thomas Davis and Scott Laird <scott@laird.com>\n"\
				" with additions and modifications by Paul Chinn\n\n"\
				"http://robotics.ee.uwa.edu.au/improv"
				),
			QMessageBox::NoIcon, 
			QMessageBox::Ok,
			QMessageBox::NoButton,
			QMessageBox::NoButton);
	about.setIconPixmap(about_icon);
	about.setMinimumHeight(about.height());
	about.setMinimumWidth(about.width());
	about.setMaximumHeight(about.height());
	about.setMaximumWidth(about.width());
	about.exec();
}

void ImprovQTApp::slotAnimPlay()
{
	bool ready=false;
	QValueList<SrcWidget*> srcWidgetList;
	QValueList<SrcWidget*>::iterator it;
	Improv* improv = Improv::Instance(0, NULL);
	srcWidgetList = improv->getSrcWidgetList();
	for(it = srcWidgetList.begin(); it != srcWidgetList.end(); it++) {
		if((*it)->isReady()) ready = true;
	}
	if(ready) {
		this->animPlay->setEnabled(false);
		this->animStop->setEnabled(true);
		this->animForward->setEnabled(false);
		this->animFastForward->setEnabled(false);
		this->animBackward->setEnabled(false);
		this->animRewind->setEnabled(false);
		improv->setPlaying(true);
		improv->setStatusMessage(PLAYINGMSG);
	}
}

void ImprovQTApp::slotAnimStop()
{
	Improv* improv = Improv::Instance(0, NULL);
	this->animStop->setEnabled(false);
	this->animPlay->setEnabled(true);
	this->animForward->setEnabled(true);
	this->animFastForward->setEnabled(true);
	this->animBackward->setEnabled(true);
	this->animRewind->setEnabled(true);
	improv->setPlaying(false);
	improv->setStatusMessage(IDLEMSG);
}
		
void ImprovQTApp::slotAnimForward()
{
	Improv* improv = Improv::Instance(0, NULL);
	improv->tick();
}

void ImprovQTApp::slotAnimFastForward()
{
	Improv* improv = Improv::Instance(0, NULL);
	improv->tick(10);
}

void ImprovQTApp::slotAnimBackward()
{
	Improv* improv = Improv::Instance(0, NULL);
	improv->tick(-1);
}

void ImprovQTApp::slotAnimRewind()
{
	Improv* improv = Improv::Instance(0, NULL);
	improv->tick(-10);
}

void ImprovQTApp::slotSetFPS(int fps)
{
	Improv* improv = Improv::Instance(0, NULL);
	improv->setFPS(fps);
}

void ImprovQTApp::slotSetUnlimitedFPS(bool toggle) {
	Improv* improv = Improv::Instance(0, NULL);
	//printf("srcWidget: %s\n", improv->getSrcWidget()->getCurrent());
	if(toggle==true) this->fpsBox->setEnabled(false);
	else this->fpsBox->setEnabled(true);
	improv->setUnlimitedFPS(toggle);
}

void ImprovQTApp::closeEvent(QCloseEvent * e) {
	slotFileQuit();
}

ImprovQTHelp::ImprovQTHelp(QWidget *parent, const char *name): QDialog( parent, name, true, WType_Modal ) {
	text = new QMultiLineEdit(this,"text");
	text->setGeometry(QRect(5,5,this->width()-10,this->height()-10));
	char helpText[] = {
	  "IMPROV - Help File\n\n" \
  	"1. IMPROV - Image Processing for Robot Vision\n\n" \
  	"IMPROV is a simple tool to test image processing functions.\n" \
	  "Images are taken from the QUICKCAM, Video for Linux device or\n" \
  	"Video for Linux II device. Operations may be concatenated, so\n" \
	  "even a more complex task can also be tested. The original image\n" \
  	"(from live camera or loaded sequence) is shown in window #1, and\n" \
		"the results of operations are shown in subsequent windows.\n\n" \
  	"2. Selecting and adding image processing operations\n\n" \
  	"The dropchoice on top of each image allows for the selection of\n" \
	  "an image processing operation to be performed on the previous image\n" \
  	"and displayed in the current image window.\n" \
	  "The chosen operation is displayed in a browser control below the\n" \
  	"image window. Multiple operations can be successively applied. The\n" \
		"order of operations can be changed by selecting an operation, and then\n" \
		"clicking the '<' or '>' buttons to move the operation up or down the list.\n" \
  	"Some operations take arguments like the threshold function. To modify the\n" \
		"parameters or an operation, simply click the operation, then select the\n" \
		"parameter from the dropbox box on the 'Parameters' toolbar. Then use the\n" \
		"slider to modify the value in the range [0.0..1.0]\n\n" \
	  "3. Modifying and deleting image processing operations\n\n" \
		"To delete an operation, select it and then click the 'Remove' button.\n\n" \
	  "4. Links\n" \
	  "IMPROV - Image Processing for Robot Vision\n" \
  	"http://robotics.ee.uwa.edu.au/improv\n"
	};
	text->setText(tr(helpText));
	text->setWordWrap(QMultiLineEdit::WidgetWidth);	
	text->setCursorPosition(0,0);
	text->setReadOnly(true);

	setName("Help");
//	setMinimumHeight(height());
//	setMinimumWidth(width());
//	setMaximumHeight(height());
//	setMaximumWidth(width());
	setCaption(tr("Help"));
}

ImprovQTHelp::~ImprovQTHelp() {

}

void ImprovQTHelp::resizeEvent(QResizeEvent * e) {
	text->setGeometry(QRect(5,5,e->size().width()-10,e->size().height()-10));
}
