/* ImprovQTOpt.cpp
 * Last modified:
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 */
/* To add new camera drivers to the options dialog, edit the code at ADD1-4
 * See my thesis appendix for detailed instructions on how to do this.
 */

#include "ImprovQTOpt.h"
#include "Improv.h"

#define V4L_STRING "Video4Linux"
#define V4L2_STRING "Video4Linux 2"
#define QCAM_STRING "QuickCam"
// ADD1: new camera types here...

ImprovQTOpt::ImprovQTOpt(QWidget *parent, const char *name, improvConfig *config)
: QDialog( parent, name, true, WType_Modal )
{
	QLabel* widthTextLabel;
	QLabel* heightTextLabel;
	QLabel* windowsTextLabel;
	QLabel* sourcesTextLabel;
	QLabel* pluginTextLabel;
	QLabel* sequenceTextLabel;
	QLabel* cameraTextLabel;
	int wwWidth, wwHeight;
	int numCols = config->getNumCols();
	int numRows = config->getNumRows();
	int extraWidth = 0;
	int extraHeight= 0;

	frame = new QFrame(this,"frame");
	frame->setFrameStyle(QFrame::Raised);
	frame->setFrameShape(QFrame::Box);
	frame->setLineWidth(1);
	frame->setMidLineWidth(0);
	// OptWidgets are 75 wide and 86 high (minimum)
	frame->setMaximumHeight(177);
	frame->setMaximumWidth(231);
	frame->setGeometry(QRect(10,10,231,177));
	QGridLayout *gridLayout;
	gridLayout = new QGridLayout(frame,numRows,numCols,2,1,"gridLayout");

	if(numCols>3) {
		extraWidth = (int)floor((double)(numCols - 3)*76);
		frame->setMaximumWidth(frame->width()+extraWidth);
		frame->setGeometry(QRect(frame->geometry().left(),
		                         frame->geometry().top(),
		                         frame->width()+extraWidth,
		                         frame->height()));
	}
	if(numRows>2) {
		extraHeight = (int)floor((double)(numRows - 2)*87);
		frame->setMaximumHeight(frame->height()+extraHeight);
		frame->setGeometry(QRect(frame->geometry().left(),
		                         frame->geometry().top(),
		                         frame->width(),
		                         frame->height()+extraHeight));
	}
	
	wwWidth = (int)((frame->width()-(2*gridLayout->margin()+gridLayout->spacing()*(numCols-1)))/numCols);
	wwHeight = (int)((frame->height()-(2*gridLayout->margin()+gridLayout->spacing()*(numRows-1)))/numRows);

	// this resizes the frame, if the child widgets don't take up the whole width/height
	if((2*gridLayout->margin()+(numCols-1)*gridLayout->spacing()+numCols*wwWidth)!=frame->width()) {
		frame->setMaximumWidth(2*gridLayout->margin()+(numCols-1)*gridLayout->spacing()+numCols*wwWidth);
	}
	if((2*gridLayout->margin()+(numRows-1)*gridLayout->spacing()+numRows*wwHeight)!=frame->height()) {
		frame->setMaximumHeight(2*gridLayout->margin()+(numRows-1)*gridLayout->spacing()+numRows*wwHeight);
	}

	optWidgets = (OptWidget **)malloc(sizeof(OptWidget *) * (config->getNumWindows()));
	if(optWidgets == NULL) {
		fprintf(stderr,"Error: Options - No memory available for opt widgets\n");
		return;
	}

	// add all the windowWidgets to the grid in the frame.
	for(int i=0;i<config->numWidgetConfigs();i++) {
		optWidgets[i] = new OptWidget(frame,"",config->getWidgetConfig(i),wwWidth,wwHeight);
		optWidgets[i]->setNumWindows(config->getNumWindows()-config->getNumSources());
		optWidgets[i]->setNumSources(config->getNumSources());
		gridLayout->addWidget(optWidgets[i],config->getWidgetConfig(i)->row,config->getWidgetConfig(i)->col);
	}

	setName("Options");
	resize(363+extraWidth, 367+extraHeight);
	setMinimumHeight(height());
	setMinimumWidth(width());
	setMaximumHeight(height());
	setMaximumWidth(width());
	setCaption(trUtf8("Options"));

	/* text labels */
	pluginTextLabel = new QLabel( this, "pluginTextLabel" );
	pluginTextLabel->setGeometry( QRect( 10, 197+extraHeight, 65, 20 ) );
	pluginTextLabel->setText( tr( "Plug-ins" ) );
	sequenceTextLabel = new QLabel( this, "sequenceTextLabel" );
	sequenceTextLabel->setGeometry( QRect( 10, 267+extraHeight, 67, 20 ) );
	sequenceTextLabel->setText( tr( "Sequences" ) );
	cameraTextLabel = new QLabel( this, "cameraTextLabel" );
	cameraTextLabel->setGeometry( QRect( 10, 297+extraHeight, 70, 20 ) );
	cameraTextLabel->setText( tr( "Camera" ) );
	windowsTextLabel = new QLabel( this, "windowsTextLabel" );
	windowsTextLabel->setGeometry( QRect( 301+extraWidth, 10, 54, 20 ) );
	windowsTextLabel->setText( tr( "Windows" ) );
	sourcesTextLabel = new QLabel( this, "sourcesTextLabel" );
	sourcesTextLabel->setGeometry( QRect( 301+extraWidth, 40, 54, 20 ) );
	sourcesTextLabel->setText( tr( "Sources" ) );
	heightTextLabel = new QLabel( this, "heightTextLabel" );
	heightTextLabel->setGeometry( QRect( 301+extraWidth, 70, 54, 20 ) );
	heightTextLabel->setText( tr( "Height" ) );
	widthTextLabel = new QLabel( this, "widthTextLabel" );
	widthTextLabel->setGeometry( QRect( 301+extraWidth, 100, 54, 20 ) );
	widthTextLabel->setText( tr( "Width" ) );

	/* multiline edits */
//	pluginMultiLineEdit = new QMultiLineEdit(this, "pluginLineEdit");
//	for(int i=0;i<config->getNumPluginPaths();i++) {
//		//pluginLineEdit->setText(tr(config->getPluginPath()));
//		pluginMultiLineEdit->insertLine(tr(config->getPluginPath(i)),i);
//	}
//	pluginMultiLineEdit->setGeometry(QRect(81, 197+extraHeight, 211+extraWidth, 60));
//	//pluginMultiLineEdit->setHScrollBarMode(QScrollView::AlwaysOff);
//	pluginMultiLineEdit->setCursorPosition(0,0);
//	QWhatsThis::add(pluginMultiLineEdit,tr("Plugins directory(s)\n\nThe directory(s) that contains ImprovQT plugins"));

	/* textedit edits */
	pluginTextEdit = new QTextEdit(this, "pluginTextEdit");
	pluginTextEdit->setTextFormat(Qt::PlainText);
	for(int i=0;i<config->getNumPluginPaths();i++) {
		QString *t = new QString(QString(config->getPluginPath(i)).stripWhiteSpace());
		pluginTextEdit->insertAt(t->append("\n"), i, 0);
	}
	pluginTextEdit->setGeometry(QRect(81, 197+extraHeight, 211+extraWidth, 60));
	pluginTextEdit->setWordWrap(QTextEdit::NoWrap);
	pluginTextEdit->setHScrollBarMode(QScrollView::AlwaysOff);
	//pluginTextEdit->setSelection(0,0,0,0);
	pluginTextEdit->setCursorPosition(0,0);
	QWhatsThis::add(pluginTextEdit,tr("Plugins directory(s)\n\nThe directory(s) that contains ImprovQT plugins"));
	pluginTextEdit->setModified(false);

	/* line edits */
	sequenceLineEdit = new QLineEdit(this, "sequenceLineEdit");
	sequenceLineEdit->setText(tr(config->getSequencePath()));
	sequenceLineEdit->setGeometry(QRect(81, 267+extraHeight, 211+extraWidth, 20));
	sequenceLineEdit->setCursorPosition(0);
	QWhatsThis::add(sequenceLineEdit,tr("Sequences directory\n\nThe directory that contains image sequences"));

	/* browse buttons */
	pluginButton = new QPushButton(this, "pluginButton");
	pluginButton->setGeometry(QRect( 301+extraWidth, 197+extraHeight, 50, 20));
	pluginButton->setText(tr("Browse"));
	pluginButton->setAutoDefault(false);
	QWhatsThis::add(pluginButton,tr("Browse for Plugins directory"));
	connect(pluginButton, SIGNAL(clicked()), this, SLOT(slotPluginButton()));
	sequenceButton = new QPushButton(this, "sequenceButton");
	sequenceButton->setGeometry(QRect(301+extraWidth, 267+extraHeight, 50, 20));
	sequenceButton->setText(tr("Browse"));
	sequenceButton->setAutoDefault(false);
	QWhatsThis::add(sequenceButton,tr("Browse for Sequences directory"));
	connect(sequenceButton, SIGNAL(clicked()), this, SLOT(slotSequenceButton()));

	/* spin boxes */
	numWindows = new QSpinBox(2, config->getNumWindows(), 1, this, "numWindows");
	numWindows->setValue(config->getNumWindows());
	numWindows->setGeometry(QRect(250+extraWidth, 10, 50, 20));
	QWhatsThis::add(numWindows,tr("Number of total windows\n\nNot implemented in this version\nPlease use the command line arguments"));
	numWindows->setEnabled(false);
	numSources = new QSpinBox(1, config->getNumSources(), 1, this, "numSources");
	numSources->setValue(config->getNumSources());
	numSources->setGeometry(QRect(250+extraWidth, 40, 50, 20));
	QWhatsThis::add(numSources,tr("Number of source image windows\n\nNot implemented in this version\nPlease use the command line arguments"));
	numSources->setEnabled(false);
	connect(numWindows, SIGNAL(valueChanged(int)), this, SLOT(slotNumWindows(int)));
	windowHeight = new QSpinBox(1,1000,1,this, "windowHeight");
	windowHeight->setValue(config->getWindowHeight());
	windowHeight->setGeometry(QRect(250+extraWidth, 70, 50, 20));
	QWhatsThis::add(windowHeight,tr("Height of each image window (pixels)"));
	connect(windowHeight, SIGNAL(valueChanged(int)), this, SLOT(slotWindowHeight(int)));
	windowWidth = new QSpinBox(1,1000,1,this, "windowWidth");
	windowWidth->setValue(config->getWindowWidth());
	windowWidth->setGeometry(QRect(250+extraWidth, 100, 50, 20));
	QWhatsThis::add(windowWidth,tr("Width of each image window (pixels)"));
	connect(windowWidth, SIGNAL(valueChanged(int)), this, SLOT(slotWindowWidth(int)));

	/* combo boxes */
	cameraComboBox = new QComboBox(FALSE, this, "cameraComboBox");
	cameraComboBox->setGeometry( QRect( 80, 297+extraHeight, 211+extraWidth, 21 ) );
#ifdef HAVE_V4L
	int v4l_pos = cameraComboBox->count();
	cameraComboBox->insertItem(tr(V4L_STRING),cameraComboBox->count());
#endif
#ifdef HAVE_V4L2
	int v4l2_pos = cameraComboBox->count();
	cameraComboBox->insertItem(tr(V4L2_STRING),cameraComboBox->count());
#endif
#ifdef HAVE_QUICKCAM
	int qcam_pos = cameraComboBox->count();
	cameraComboBox->insertItem(tr(QCAM_STRING),cameraComboBox->count());
#endif
	// ADD2: new camera types here...
	QWhatsThis::add(cameraComboBox,tr("Type of Camera to use"));
	switch(config->getCameraType()) {
#ifdef HAVE_V4L
		case V4L: cameraComboBox->setCurrentItem(v4l_pos);
		break;
#endif
#ifdef HAVE_V4L2
		case V4L2: cameraComboBox->setCurrentItem(v4l2_pos);
		break;
#endif
#ifdef HAVE_QUICKCAM
		case QCAM: cameraComboBox->setCurrentItem(qcam_pos);
		break;
#endif
		default: cameraComboBox->setCurrentItem(0);
	}
	// ADD3: new camera types here...

	/* buttons */
	cancelButton = new QPushButton(this, "cancelButton");
	cancelButton->setGeometry(QRect(301+extraWidth, 337+extraHeight, 50, 20));
	cancelButton->setText(tr("Cancel"));
	cancelButton->setAutoDefault(false);
	QWhatsThis::add(cancelButton,tr("Cancel and close options"));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(slotCancelButton()));
	okButton = new QPushButton(this, "okButton");
	okButton->setGeometry(QRect(251+extraWidth, 337+extraHeight, 40, 20));
	okButton->setText(tr("OK"));
	okButton->setAutoDefault(true);
	QWhatsThis::add(okButton,tr("Save and close options"));
	connect(okButton, SIGNAL(clicked()), this, SLOT(slotOkButton()));

	/* tab order */
	this->setTabOrder(numWindows, numSources);
	this->setTabOrder(numSources, windowHeight);
	this->setTabOrder(windowHeight, windowWidth);
	this->setTabOrder(windowWidth, pluginTextEdit);
	this->setTabOrder(pluginTextEdit, pluginButton);
//	this->setTabOrder(windowWidth, pluginMultiLineEdit);
//	this->setTabOrder(pluginMultiLineEdit, pluginButton);
	this->setTabOrder(pluginButton, sequenceLineEdit);
	this->setTabOrder(sequenceLineEdit, sequenceButton);
	this->setTabOrder(sequenceButton, cameraComboBox);
	this->setTabOrder(cameraComboBox, okButton);
	this->setTabOrder(okButton, cancelButton);
	this->setTabOrder(cancelButton, numWindows);

	//this->pluginPathsModified = false;

	/* set focus */
	okButton->setFocus();
}

ImprovQTOpt::~ImprovQTOpt() {
	// no need to delete child widgets, Qt does it all for us
}

void ImprovQTOpt::slotOkButton() {
	QValueList<SrcWidget*> srcWidgetList;
	QValueList<SrcWidget*>::iterator srcIt;
	QValueList<SeqWidget*> seqWidgetList;
	QValueList<SeqWidget*>::iterator seqIt;
	Improv* improv = Improv::Instance(0, NULL);
	improvConfig::widgetConfig **newConfigs;

	newConfigs = (improvConfig::widgetConfig **)malloc(sizeof(improvConfig::widgetConfig *)*numWindows->value());
	for(int i=0;i<numWindows->value();i++) {
		newConfigs[i] = optWidgets[i]->getConfig();
	}
	if(!improv->config->verifyWidgetConfig(newConfigs,numWindows->value(),numWindows->value(),numSources->value())) {
		QMessageBox invalidDialog("Invalid", "The window configuration you have\nselected is invalid. Please try again.",
					QMessageBox::Critical,
					QMessageBox::Ok | QMessageBox::Default,
					QMessageBox::NoButton,
					QMessageBox::NoButton,
					this, "invalidDialog", true, WStyle_Dialog);
		invalidDialog.exec();
		return;
	}
	QMessageBox busyDialog("Updating Options", "Please wait",
				QMessageBox::Information,
				QMessageBox::NoButton,
				QMessageBox::NoButton,
				QMessageBox::NoButton,
				this, "busyDialog", true, WStyle_DialogBorder);
	busyDialog.show();

	//if(strcmp(improv->config->getPluginPath(),pluginLineEdit->text().latin1())!=0) {
	//if(pluginPathsModified==true||pluginMultiLineEdit->edited()==true) {
	if(pluginTextEdit->isModified()==true) {
		improv->config->clearPluginPaths();
		for(int i=0;i<pluginTextEdit->lines();i++) {
		//for(int i=0;i<pluginMultiLineEdit->numLines();i++) {
			// TOFIX: clean this up!
			QString temp = pluginTextEdit->text(i);
			//QString temp = pluginMultiLineEdit->textLine(i);
			QString temp2 = temp.stripWhiteSpace();
			improv->config->addPluginPath((char *)temp2.latin1());
		}
		//improv->config->setPluginPath((char *)pluginMultiLineEdit->text().latin1());
		improv->constructPluginMenu();
		if(improv->getPluginMenu() == NULL) {
			// options created null plugin menu -> disable add buttons
			seqWidgetList = improv->getSeqWidgetList();
			for(seqIt = seqWidgetList.begin(); seqIt != seqWidgetList.end(); seqIt++) {
				(*seqIt)->disablePopUp();
			}
		}
		else {
			// options created new plugin menu -> update add buttons
			seqWidgetList = improv->getSeqWidgetList();
			for(seqIt = seqWidgetList.begin(); seqIt != seqWidgetList.end(); seqIt++) {
				(*seqIt)->setPopUpMenu(improv->getPluginMenu());
			}
		}
	}
#ifdef HAVE_V4L
	if((QString::compare(cameraComboBox->currentText(),tr(V4L_STRING))==0)&&
		 (improv->config->getCameraType()!=V4L)) {
		improv->config->setCameraType(V4L);
	}
#endif
#ifdef HAVE_V4L2
	if((QString::compare(cameraComboBox->currentText(),tr(V4L2_STRING))==0)&&
		 (improv->config->getCameraType()!=V4L2)) {
		improv->config->setCameraType(V4L2);
	}
#endif
#ifdef HAVE_QUICKCAM
	if((QString::compare(cameraComboBox->currentText(),tr(QCAM_STRING))==0)&&
		 (improv->config->getCameraType()!=QCAM)) {
		improv->config->setCameraType(QCAM);
	}
#endif
	// ADD4: new camera types here...

	if((improv->config->getWindowHeight()!=windowHeight->value())||
		 (improv->config->getWindowWidth()!=windowWidth->value())) {
		improv->config->setWindowHeight(windowHeight->value());
		improv->config->setWindowWidth(windowWidth->value());
		srcWidgetList = improv->getSrcWidgetList();
		if(strcmp(improv->config->getSequencePath(),sequenceLineEdit->text().latin1())!=0) {
			improv->config->setSequencePath((char *)sequenceLineEdit->text().latin1());
			for(srcIt = srcWidgetList.begin(); srcIt != srcWidgetList.end(); srcIt++) {
				(*srcIt)->reload(true);
			}	
		}
		else {
			for(srcIt = srcWidgetList.begin(); srcIt != srcWidgetList.end(); srcIt++) {
				(*srcIt)->reload(false);
			}	
		}
		seqWidgetList = improv->getSeqWidgetList();
		for(seqIt = seqWidgetList.begin(); seqIt != seqWidgetList.end(); seqIt++) {
			(*seqIt)->reload();
		}
	}
	else if(strcmp(improv->config->getSequencePath(),sequenceLineEdit->text().latin1())!=0) {
		improv->config->setSequencePath((char *)sequenceLineEdit->text().latin1());
		srcWidgetList = improv->getSrcWidgetList();
		for(srcIt = srcWidgetList.begin(); srcIt != srcWidgetList.end(); srcIt++) {
			(*srcIt)->reload(true);
		}	
	}
	for(int i=0;i<numWindows->value();i++) {
		// update src + seq from optwidgets
		if(optWidgets[i]->isModified()) {
			// to trigger isModified
			improv->config->setModified(true);
			improv->config->getWidgetConfig(i)->source = optWidgets[i]->getSource();
			improv->config->getWidgetConfig(i)->sourceId = optWidgets[i]->getSourceId();
			improv->config->getWidgetConfig(i)->position = optWidgets[i]->getPosition();
			if(improv->config->getWidgetConfig(i)->source) {
				// src widgets
				if(!optWidgets[i]->getSource()) {
					/** @todo change a SrcWidget to a SeqWidget in ImprovQTview, when user changes config. */
				}
			}
			else {
				// seq widgets
				if(optWidgets[i]->getSource()) {
					/** @todo change a SegWidget to a SrcWidget in ImprovQTview, when user changes config. */
				}
				else {
					improv->getSeqWidget(improv->config->getWidgetConfig(i)->id)->setSourceId(optWidgets[i]->getSourceId());
					improv->getSeqWidget(improv->config->getWidgetConfig(i)->id)->setPosition(optWidgets[i]->getPosition());
				}
			}
		}
	}
	if(improv->config->getNumWindows()!=numWindows->value()) {
		improv->config->setNumWindows(numWindows->value());
		/** @todo Delete windows from ImprovQTview when a user reduces the number of windows. */
		//delete parent->view;
		//view = new ImprovQTView(app, app->doc);
		//parent->setCentralWidget(view);
		// OR
		//view->reload();
	}
	busyDialog.close();
	close();
	if(improv->config->isModified()) {
		improv->setStatusMessage("Options updated",2000);
	}
	else {
		improv->setStatusMessage(IDLEMSG);
	}
}

void ImprovQTOpt::slotCancelButton() {
	Improv* improv = Improv::Instance(0, NULL);
	improv->setStatusMessage("Options aborted",2000);
	close();
}

void ImprovQTOpt::slotPluginButton() {
	Improv* improv = Improv::Instance(0, NULL);
	improv->setStatusMessage("Choosing Plugin Directory...");

	QString dirName = QFileDialog::getExistingDirectory(tr(pluginTextEdit->text(0)),this,"pluginBrowser","Choose Plugin Directory", true);
	//QString dirName = QFileDialog::getExistingDirectory(tr(pluginMultiLineEdit->textLine(0)),this,"pluginBrowser","Choose Plugin Directory", true);
	if (!dirName.isEmpty()) {
		//pluginLineEdit->setText(dirName);
		pluginTextEdit->insertParagraph(dirName,-1);
		//pluginMultiLineEdit->insertLine(dirName,-1);
		this->pluginPathsModified = true;
		improv->setStatusMessage("Options");
	}
	else {
		improv->setStatusMessage("Selection aborted",2000);
	}
}

void ImprovQTOpt::slotSequenceButton() {
	Improv* improv = Improv::Instance(0, NULL);
	improv->setStatusMessage("Choosing Sequence Directory...");

	QString dirName = QFileDialog::getExistingDirectory(tr(sequenceLineEdit->text()),this,"sequenceBrowser","Choose Sequence Directory", true);
	if (!dirName.isEmpty()) {
		sequenceLineEdit->setText(dirName);
		improv->setStatusMessage("Options");
	}
	else {
		improv->setStatusMessage("Selection aborted",2000);
	}
}

void ImprovQTOpt::slotWindowHeight(int value) {
	//localConfig->setWindowHeight(value);
}

void ImprovQTOpt::slotWindowWidth(int value) {
	//localConfig->setWindowWidth(value);
}

void ImprovQTOpt::slotNumWindows(int value) {
	//localConfig->setNumSeqWindows(value);
}

/*void ImprovQTOpt::closeEvent(QCloseEvent * e) {
	Improv* improv = Improv::Instance(0, NULL);
	improv->redraw();
	this->close();
	//slotCancelButton();
}*/

OptWidget::OptWidget(QWidget *parent, const char *name, improvConfig::widgetConfig *config, int width, int height) : QWidget(parent)
{
	QLabel* positionTextLabel;
	QLabel* sourceTextLabel;
	QFrame *frame;
	this->id = config->id;
	this->col = config->col;
	this->row = config->row;
	this->setMaximumWidth(width);
	this->setMaximumHeight(height);
	frame = new QFrame(this,"wwFrame");
	frame->setFrameStyle(QFrame::Raised);
	frame->setFrameShape(QFrame::Box);
	frame->setLineWidth(1);
	frame->setMidLineWidth(0);
	frame->setGeometry(QRect(0,0,width,height));
	
	sourceCheckBox = new QCheckBox(tr("Source"),this,"sourceCheckBox");
	sourceCheckBox->setGeometry(QRect((int)((width-67)/2), 2, 67, 20));
	sourceCheckBox->setChecked(config->source);
	sourceCheckBox->setEnabled(false);
	QWhatsThis::add(sourceCheckBox,tr("Toggle source window\n\nNot implemented in this version\nPlease use the command line arguments"));
	connect(sourceCheckBox, SIGNAL(toggled(bool)), this, SLOT(slotSource(bool)));

	combineCheckBox = new QCheckBox(tr("Combine"),this,"combineCheckBox");
	combineCheckBox->setGeometry(QRect((int)((width-67)/2), 19, 67, 20));
	if(config->sourceId==-1) combineCheckBox->setChecked(true);
	combineCheckBox->setEnabled(!config->source);
	QWhatsThis::add(combineCheckBox,tr("Toggle combination window\n\nThis will cause images from all sources to be combined in this widget"));
	connect(combineCheckBox, SIGNAL(toggled(bool)), this, SLOT(slotCombine(bool)));

	sourceSpinBox = new QSpinBox(0, config->sourceId, 1, frame, "sourceSpinBox");
	sourceSpinBox->setGeometry(QRect((int)((width-67)/2), 39, 30, 20));
	if(config->sourceId==-1) slotCombine(true);
	else sourceSpinBox->setValue(config->sourceId);
	QWhatsThis::add(sourceSpinBox,tr("Source Id of this window"));
	connect(sourceSpinBox, SIGNAL(valueChanged(int)), this, SLOT(slotSourceId(int)));
	if(config->source) sourceSpinBox->setEnabled(false);

	if(config->source) positionSpinBox = new QSpinBox(0, 0, 1, frame, "positionSpinBox");
	else positionSpinBox = new QSpinBox(1, config->position, 1, frame, "positionSpinBox");
	positionSpinBox->setGeometry(QRect((int)((width-67)/2), 62, 30, 20));
	positionSpinBox->setValue(config->position);
	QWhatsThis::add(positionSpinBox,tr("Position of this window"));
	connect(positionSpinBox, SIGNAL(valueChanged(int)), this, SLOT(slotPosition(int)));
	if(config->source) positionSpinBox->setEnabled(false);

	/* text labels */
	sourceTextLabel = new QLabel(frame, "sourceTextLabel");
	sourceTextLabel->setGeometry(QRect((int)((width-67)/2)+35, 39, 30, 20));
	sourceTextLabel->setText(tr("SrcId"));
	positionTextLabel = new QLabel(frame, "positionTextLabel");
	positionTextLabel->setGeometry(QRect((int)((width-67)/2)+35, 62, 30, 20));
	positionTextLabel->setText(tr("Posn"));

	modified = false;
}

OptWidget::~OptWidget() {
}

void OptWidget::slotSource(bool on) {
	modified = true;
	if(on) {
		positionSpinBox->setMinValue(0);
		positionSpinBox->setMaxValue(0);
		positionSpinBox->setValue(0);
	}
	else {
		positionSpinBox->setMinValue(1);
		positionSpinBox->setMaxValue(numWindows);
	}
	positionSpinBox->setEnabled(!on);
	sourceSpinBox->setEnabled(!on);
}

void OptWidget::slotCombine(bool value) {
	if(!sourceCheckBox->isChecked()) {
		if(value) {
			sourceSpinBox->setMinValue(-1);
			sourceSpinBox->setValue(-1);
			sourceSpinBox->setEnabled(false);
		}
		else {
			sourceSpinBox->setMinValue(0);
			sourceSpinBox->setValue(0);
			sourceSpinBox->setEnabled(true);
		}
	}
}

void OptWidget::slotSourceId(int value) {
	modified = true;
}

void OptWidget::slotPosition(int value) {
	modified = true;
}

improvConfig::widgetConfig *OptWidget::getConfig(void) {
	improvConfig::widgetConfig *config;
	config = (improvConfig::widgetConfig *)malloc(sizeof(improvConfig::widgetConfig));
	config->id = this->id;
	config->col = this->col;
	config->row = this->row;
	config->position = this->positionSpinBox->value();
	config->source = this->sourceCheckBox->isChecked();
	config->sourceId = this->sourceSpinBox->value();
	return config;	
}

bool OptWidget::getSource(void) {
	return sourceCheckBox->isChecked();
}

int OptWidget::getSourceId(void) {
	return sourceSpinBox->value();
}

int OptWidget::getPosition(void) {
	return positionSpinBox->value();
}

void OptWidget::setNumWindows(int num) {
	numWindows = num;
	positionSpinBox->setMaxValue(num);
}

void OptWidget::setNumSources(int num) {
	numSources = num;
	sourceSpinBox->setMaxValue(num-1);
	combineCheckBox->setEnabled(num>1);
}

bool OptWidget::isModified(void) {
	return modified;
}

