/* ImprovQTOpt.h
 * Last modified: 
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 */

#ifndef IMPROVQTOPT_H
#define IMPROVQTOPT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qvariant.h>
#include <qdialog.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qrect.h>
#include <qcheckbox.h>
//#include <qtextedit.h> // new as of QT 3... removed to allow porting.
#include <qmultilineedit.h>

#include "Improv.h"
#include "ImprovQT.h"
#include "improvConfig.h"

/** @class OptWidget
 * Widget used within the ImprovQTOpt dialog to alter the configuration of the source and sequence widgets.
 * @see ImprovQTOpt
 */
class OptWidget : public QWidget
{
	Q_OBJECT
	public:
		/** Constructor. */
		OptWidget(QWidget *parent=0, const char *name=0, improvConfig::widgetConfig *config=0, int width=0, int height=0);
		/** Destructor. Deletes the instance of the class. */
		~OptWidget();
		/** */
		improvConfig::widgetConfig *getConfig(void);
		/** */
		bool getSource(void);
		/** */
		int getSourceId(void);
		/** */
		int getPosition(void);
		/** */
		void setNumWindows(int num);
		/** */
		void setNumSources(int num);
		/** */
		bool isModified(void);

	public slots:
		/** */
		void slotSource(bool value);
		/** */
		void slotCombine(bool value);
		/** */
		void slotSourceId(int value);
		/** */
		void slotPosition(int value);

	private:
		/** Id of the widget */
		int id;
		/** The column position of the widget */
		int col;
		/** The row position of the widget */
		int row;
		/** If the widget configuration has been modified */
		bool modified;
		/** The number of windows present in the application. Provides a boundary on inputs. */
		int numWindows;
		/** The number of source present in the application. Provides a boundary on inputs. */
		int numSources;
		/** Source check box. Used to toggle whether the widget is a source or a sequence widget. */
		QCheckBox* sourceCheckBox;
		/** Combine check box. Used to toggle whether the widget is a combine sequence widget. */
		QCheckBox* combineCheckBox;
		/** Source spin box. Used to set the sourceId of the widget. */
		QSpinBox* sourceSpinBox;
		/** Position spin box. Used to sets the position of the widget. */
		QSpinBox* positionSpinBox;
		
};

/** @class ImprovQTOpt
 * Options dialog box.
 */
class ImprovQTOpt : public QDialog
{
	Q_OBJECT
	public:
		/** Constructor */
		ImprovQTOpt(QWidget *parent=0, const char *name=0, improvConfig *config=0);
		/** Destructor. Deletes the instance of the class. */
		~ImprovQTOpt();

	public slots:
		/** */
		void slotOkButton();
		/** */
		void slotCancelButton();
		/** */
		void slotPluginButton();
		/** */
		void slotSequenceButton();
		/** */
		void slotWindowHeight(int value);
		/** */
		void slotWindowWidth(int value);
		/** */
		void slotNumWindows(int value);
		
	protected:
		/** */
		//void closeEvent(QCloseEvent * e);
		
	private:
 		/** */
		QSpinBox* windowWidth;
		/** */
		QSpinBox* windowHeight;
		/** */
		QSpinBox* numWindows;
		/** */
		QSpinBox* numSources;
		/** */
		QPushButton* okButton;
		/** */
		QPushButton* cancelButton;
		/** */
		QPushButton* pluginButton;
		/** */
		QPushButton* sequenceButton;
		/** */
		//QMultiLineEdit* pluginMultiLineEdit;
		QTextEdit *pluginTextEdit;
		bool pluginPathsModified;
		/** */
		QLineEdit* sequenceLineEdit;
		/** */
		QComboBox* cameraComboBox;
		/** */
		QFrame *frame;
		/** */
		OptWidget **optWidgets;
		
};

#endif
