#include "motion_field.h"  
#include "../FW/labImage.h"
  
#if defined(__cplusplus)
extern "C" { 
#endif

#ifndef _BYTE
#define _BYTE
  typedef unsigned char BYTE;
#endif
 
#ifndef _FIELD
#define _FIELD  
  typedef struct {
    int win_value;
    BYTE win_dir;
    BYTE win_frameNr;
    BYTE incon_flag;
  } field;
#endif  
  
  int calculate_optic_flow(Picture *p_src, 
			   int patch_size, 
			   int S,
			   vec_field *output_field,
				 int* count_pic
				 );
  
  void shift(Picture *p_pic1, 
	     Picture *p_shifted_pic,
	     int dir );

  void diffi(Picture *p_in1,
	     Picture *p_in2,
	     Picture *p_diff);
  
  int partial_row_sum(Picture *p_diff,
		      int width, int height, int sub_width,
		      int startx, int starty,
		      int patch_size,
		      int *ip_tmp2);
  
  int partial_col_sum(int *ip_tmp2,
		      int width, int height,
		      int patch_size,
		      int *ip_tmp3);
  
  void make_camus_field(field m_field[],
			int width_mfield, int height_mfield, 
			vec_field *motion_field); 
  
  void write_in_camus_motion_field(vec_field *camus_field,
				   int x1, int y1, int dir, int frameNr);
  
#if defined(__cplusplus)
}
#endif
