/* ParamWidget.h
 * Last modified: 
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class ParamWidget
 * Parameter widget, used for control the variables of each image operation.
 */

#ifndef PARAMWIDGET_H
#define PARAMWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

// QT includes
#include <qwidget.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qwhatsthis.h>

#include "SeqWidget.h"

#define MAX_VALUE 1000
#define REFRESH_INTERVAL 10

class ParamWidget : public QWidget
{
	Q_OBJECT
	public:
		/** Constructor. */
		ParamWidget(QWidget* parent=0, const char* name=0, int minimumWidth=0);
		/** Destructor. Deletes the instance of the class. */
		~ParamWidget();

		/** */
		void setPluginItem(PluginItem* pi);
		/** */
		void activateParams(int numParams, QStringList* paramNames, float* params);
		/** */
		void disable(void);
	
	protected:
		/** */
		QBoxLayout* layout;
		/** */
		QComboBox* nameBox;
		/** */
		QSlider* valueSlider;
		/** */
		QLabel* valueLabel;

	private:
		/** */
		float* params;
		/** */
		int updateCounter;
	
	private slots:
		/** */
		void selectParam(int index);
		/** */
		void paramChanged(int value);
		
};

#endif
